% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawDotplot.R
\name{DrawDotplot}
\alias{DrawDotplot}
\title{Draw dot plot for GSEA results of cross-regional DE genes}
\usage{
DrawDotplot(
  allCTres,
  CT = 1,
  angle = 20,
  vjust = 0.9,
  hjust = 1,
  padj_cutoff = 1,
  topN = 20,
  chooseP = "padj",
  eachN = NULL
)
}
\arguments{
\item{allCTres}{A list of GSEA results for all cell types.}

\item{CT}{A number of the interested cell type, e.g., 1, 2, 3.}

\item{angle}{A number of plotting parameter, angle of the x axis label.}

\item{vjust}{A number of vertical adjustment in plotting.}

\item{hjust}{A number of horizontal adjustment in plotting.}

\item{padj_cutoff}{A cutoff number of adjusted p value.}

\item{topN}{A number of the plotted top pathways.}

\item{chooseP}{A character string for the p value that used in plotting, e.g., "padj" or "pval".}

\item{eachN}{The maximum number of pathways in each cell type.}
}
\value{
A plot object
}
\description{
Draw dot plot for GSEA results of cross-regional DE genes
}
\examples{
data(exampleRes)
allCTres <- DoGSEA(exampleRes, whichDB = "hallmark", withProp = TRUE)
DrawDotplot(allCTres, CT = 1, angle = 15, vjust = 1, chooseP = "padj")

}
