% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FactorisedExperiment.R,
%   R/methods-ModularExperiment.R, R/methods-ReducedExperiment.R
\name{[,FactorisedExperiment,ANY,ANY,ANY-method}
\alias{[,FactorisedExperiment,ANY,ANY,ANY-method}
\alias{[<-,FactorisedExperiment,ANY,ANY,FactorisedExperiment-method}
\alias{[,ModularExperiment,ANY,ANY,ANY-method}
\alias{[<-,ModularExperiment,ANY,ANY,ModularExperiment-method}
\alias{slice}
\alias{[,ReducedExperiment,ANY,ANY,ANY-method}
\alias{[<-,ReducedExperiment,ANY,ANY,ReducedExperiment-method}
\title{Extract and replace parts of ReducedExperiment objects}
\usage{
\S4method{[}{FactorisedExperiment,ANY,ANY,ANY}(x, i, j, k, ..., drop = FALSE)

\S4method{[}{FactorisedExperiment,ANY,ANY,FactorisedExperiment}(x, i, j, k, ...) <- value

\S4method{[}{ModularExperiment,ANY,ANY,ANY}(x, i, j, k, ..., drop = FALSE)

\S4method{[}{ModularExperiment,ANY,ANY,ModularExperiment}(x, i, j, k, ...) <- value

\S4method{[}{ReducedExperiment,ANY,ANY,ANY}(x, i, j, k, ..., drop = FALSE)

\S4method{[}{ReducedExperiment,ANY,ANY,ReducedExperiment}(x, i, j, k, ...) <- value
}
\arguments{
\item{x}{\link[ReducedExperiment]{ReducedExperiment} object.}

\item{i}{Slicing by rows (features, usually genes).}

\item{j}{Slicing by columns (samples/observations).}

\item{k}{Slicing by reduced dimensions.}

\item{...}{Additional arguments to be passed to the parent method.}

\item{drop}{Included for consistency with other slicing methods.}

\item{value}{Value to be used to replace part of the object.}
}
\value{
A \link[ReducedExperiment]{ReducedExperiment} object, potentially
sliced by rows (\code{i}), columns (\code{j}) and components (\code{k}).
}
\description{
Method permits slicing of \link[ReducedExperiment]{ReducedExperiment}
objects.
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of components (i.e., factors/modules)

rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "component")

# Create a randomised ReducedExperiment container
re <- ReducedExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data
)

# Slice our object by rows (1:50), columns (1:20) and components (1:5)
# re[i, j, k, ...]
sliced_re <- re[1:50, 1:20, 1:5]
sliced_re

# We can also assign our subsetted object back to the original
re[1:50, 1:20, 1:5] <- sliced_re
re

}
\author{
Jack Gisby
}
