% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{plotModulePreservation}
\alias{plotModulePreservation}
\title{Plot module preservation statistics}
\usage{
plotModulePreservation(
  modulePreservation_results,
  show_random = TRUE,
  remove_module = NULL
)
}
\arguments{
\item{modulePreservation_results}{The output of
\link[ReducedExperiment]{modulePreservation}}

\item{show_random}{If \code{TRUE}, shows the random module in the plots.}

\item{remove_module}{The name of a module to be hidden from the plots.}
}
\value{
Two \code{ggplot2} plot objects combined by patchwork. Plots the
module preservation statistics generated by
\link[ReducedExperiment]{modulePreservation}.
}
\description{
Plot module preservation statistics
}
\examples{
# Get random ModularExperiments with rnorm, with 100 rows (features),
# 20 columns (observations) and 5/10 modules
me_1 <- ReducedExperiment:::.createRandomisedModularExperiment(100, 20, 5)
me_2 <- ReducedExperiment:::.createRandomisedModularExperiment(100, 20, 10)

# Test module preservation (test modules from dataset 1 in dataset 2)
mp <- modulePreservation(me_1, me_2, verbose = 0, nPermutations = 3)

# No significant preservation, since these were random modules
plotModulePreservation(mp)

}
\author{
Jack Gisby
}
