% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ReducedExperiment.R
\name{getGeneIDs}
\alias{getGeneIDs}
\alias{getGeneIDs,ReducedExperiment-method}
\title{Gets alternative gene annotations from biomaRt}
\usage{
\S4method{getGeneIDs}{ReducedExperiment}(
  object,
  gene_id_col = "rownames",
  gene_id_type = "ensembl_gene_id",
  ids_to_get = c("hgnc_symbol", "entrezgene_id"),
  dataset = "hsapiens_gene_ensembl",
  mart = NULL,
  biomart_out = NULL
)
}
\arguments{
\item{object}{\link[ReducedExperiment]{ReducedExperiment} object.}

\item{gene_id_col}{The column in \code{rowData(object)} that will be used to
query biomaRt. Setting this to "rownames" instead uses \code{rownames(object)}
for matching.}

\item{gene_id_type}{The type of attribute to be used to query with biomaRt.
See the \code{filters} argument of \link[biomaRt]{getBM}.}

\item{ids_to_get}{The type of attribute to get from biomaRt.
See the \code{attributes} argument of \link[biomaRt]{getBM}.}

\item{dataset}{The Ensembl dataset to retrieve. See the \code{dataset} argument
of \link[biomaRt]{useEnsembl}. If \code{mart} is not \code{NULL}, this argument is
ignored.}

\item{mart}{An optional mart object to use. See the \code{mart} argument of
\link[biomaRt]{getBM}. If provided, this object is used to query biomart
for the conversion of gene IDs. If \code{biomart_out} is not \code{NULL}, this argument
is ignored.}

\item{biomart_out}{An optional \code{data.frame} containing the output of a call
to \link[biomaRt]{getBM}. If provided, this object is used for the conversion
of gene IDs.}
}
\value{
Returns the original object, with additional variables added to
the \code{rowData} slot.
}
\description{
Uses \link[biomaRt]{getBM} to get alternative gene IDs for
\link[ReducedExperiment]{ReducedExperiment} objects. The new annotations
are added as columns to the input object's \code{rowData}
}
\examples{
set.seed(2)
airway <- ReducedExperiment:::.getAirwayData(n_features = 500)

set.seed(1)
airway_fe <- estimateFactors(airway, nc = 2, use_stability = FALSE, method = "imax")

# rowData before getting additional gene IDs
rowData(airway_fe)

# For this example we run `getGeneIDs` using a preloaded biomart query
# (`biomart_out`) to avoid actually querying ensembl during testing
# Note: do not use this file for your actual data
biomart_out <- readRDS(system.file(
    "extdata",
    "biomart_out.rds",
    package = "ReducedExperiment"
))
airway_fe <- getGeneIDs(airway_fe, biomart_out = biomart_out)

# rowData after getting additional gene IDs
rowData(airway_fe)

}
\seealso{
\code{\link[biomaRt:useEnsembl]{biomaRt::useEnsembl()}}, \code{\link[biomaRt:getBM]{biomaRt::getBM()}}
}
\author{
Jack Gisby
}
