% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedOtherMethods.R
\docType{methods}
\name{deleteEdges,character-method}
\alias{deleteEdges,character-method}
\alias{deleteEdges}
\alias{deleteEdges,data.frame-method}
\title{deleteEdges}
\usage{
\S4method{deleteEdges}{character}(edges, ...)

\S4method{deleteEdges}{data.frame}(edges, ...)
}
\arguments{
\item{edges}{A vertex sequence <vector of strings> or data frame of ncol=2.}

\item{...}{Arguments passed to internal checks (ignore).}
}
\value{
Remove graph objects from RedeR app.
}
\description{
Delete edges from an active RedeR application.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create some edges as a data.frame
edges <- data.frame(
    A = c("n1", "n1", "n1", "n1"),
    B = c("n2", "n3", "n4", "n5")
)

\donttest{
# Start the RedeR interface
startRedeR()

# Add and delete edges
addEdges(edges)
deleteEdges(c("n1", "n3", "n1", "n6"))
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
