% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_reactome_data_types}
\alias{get_reactome_data_types}
\title{ReactomeGSA supported data types}
\usage{
get_reactome_data_types(
  print_types = TRUE,
  return_result = FALSE,
  reactome_url = NULL
)
}
\arguments{
\item{print_types}{If set to \code{TRUE} (default) a (relatively) nice formatted version of the result is printed.}

\item{return_result}{If set to \code{TRUE}, the result is returned as a data.frame (see below)}

\item{reactome_url}{URL of the Reactome API Server. Overwrites the URL set in the 'reactome_gsa.url' option.
Specific ports can be set using the standard URL specification (for example http://your.service:1234)}
}
\value{
A \code{data.frame} containing one row per data type with its \code{id} and \code{description}.
}
\description{
ReactomeGSA supported data types
}
\examples{
# retrieve the avialable data types
available_types <- get_reactome_data_types(print_types = FALSE,  return_result = TRUE)

# print all data type ids
available_types$id

# simply print the available methods
get_reactome_data_types()
}
\seealso{
Other Reactome Service functions: 
\code{\link{get_reactome_methods}()}
}
\author{
Johannes Griss
}
\concept{Reactome Service functions}
