% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwa_aln.R
\name{bwa_aln}
\alias{bwa_aln}
\title{R wrapper to run BWA alignment tool BWA-backtrack}
\usage{
bwa_aln(
  type = c("single", "paired"),
  index_prefix,
  fastq_files,
  sai_files,
  ...
)
}
\arguments{
\item{type}{String specifying type of reads:
"single" for single-end reads (default) or
"paired" for paired-end reads.}

\item{index_prefix}{String specifying prefix of the BWA index.}

\item{fastq_files}{Character vector specifying paths of fastq files.
If \code{type=="single"}, must be of length 1.
If \code{type=="paired"}, must be of length 2.}

\item{sai_files}{Character vector specifying filenames of the BWA
aligmment output files.
If \code{type=="single"}, must be of length 1.
If \code{type=="paired"}, must be of length 2.}

\item{...}{Other arguments to pass to the \code{bwa aln} alignment.}
}
\value{
No return value. Output files from bwa aln alignment are
    produced as side effect.
}
\description{
R wrapper to run BWA alignment tool BWA-backtrack.
}
\examples{
dir <- tempdir()
fasta <- system.file(package="Rbwa",
                     "fasta/chr12.fa")
fastq <- system.file(package="Rbwa",
                     "fastq/sequences.fastq")
index_prefix <- file.path(dir,"chr12")
bwa_build_index(fasta, index_prefix=index_prefix)

bwa_aln(index_prefix=index_prefix,
        fastq_files=fastq,
        sai_files=file.path(dir, "output.sai"))

}
\author{
Jean-Philippe Fortin
}
