\name{bowtie_build}
\alias{bowtie_build}
\alias{bowtie}
\alias{bowtie_build_usage}
\alias{bowtie_usage}
\alias{bowtie_version}

\title{
Interface to bowtie
}

\description{
The following functions can be used to call the bowtie and bowtie-build binaries.

We recommend to use the \pkg{QuasR} package instead of using \code{bowtie} and \code{bowtie_build} directly. \pkg{QuasR} provides a simpler interface than \pkg{Rbowtie} and covers the whole analysis workflow of typical ultra-high throughput sequencing experiments, starting from the raw sequence reads, over pre-processing and alignment, up to quantification.
}

\usage{
bowtie_build(references, outdir, ..., prefix = "index", force = FALSE,
strict = TRUE, execute = TRUE)

bowtie(sequences, index, ..., type = c("single", "paired", "crossbow"),
outfile, force = FALSE, strict = TRUE, execute = TRUE)

bowtie_build_usage()

bowtie_usage()

bowtie_version()
}

\arguments{
  
  \item{references}{Character vector. The path to the files containing
    the references for which to build a bowtie index.  }
  
  \item{outdir}{Character scalar. The path to the output directory in
    which to store the bowtie index. If the directory already exists,
    the function function will cast an error, unless
    \code{force==TRUE}.}

  \item{prefix}{Character scalar. The prefix to use for the bowtie index
    files.}


  \item{sequences}{If \code{type} is either \code{single} or
    \code{crossbow}, a character vector of filenames if additional
    argument \code{c==FALSE}, otherwise a vector of read sequences. If
    \code{type} is \code{paired}, a list of filnames ore sequences of
    length 2, where the first list item corresponds to the fist mate
    pair sequences, and the second list item to the second mate pair
    sequences.}
  
  \item{index}{Character scalar. The path to the bowtie index and prefix
    to align against, in the form \code{</path/to/index>/<prefix>}.}
  
  
  \item{type}{Character scalar, one in \code{c("single", "paired",
      "crossbow")}. If \code{single}, the input sequences are
    interpreted as single reads. If \code{paired}, they are supposed
    to be mate pair reads and if \code{crossbow}, they are considered
    to be Crossbow-style reads.}
  
  \item{outfile}{Character scalar. A path to a files used for the
    alignment output. If missing, the alignments will be returned as a
    regular R character vector.}
  
  \item{force}{Logical. Force overwriting of \code{outdir} or
    \code{outfile}.}
  
  \item{strict}{Logical. Turn off strict checking of input arguments.}
  
  \item{execute}{Logical scalar. Whether to execute the assembled shell
    command. If \code{FALSE}, return a string with the command.}

  \item{\dots}{Additional arguments to be passed on to the binaries. See
    below for details.}
 
}


\details{

  All additional arguments in \code{...} are interpreted as additional
  parameters to be passed on to the binaries. For flags, those are
  supposed to be logicals (e.g., \code{quiet=TRUE} will be translated
  into \code{--q}, \code{q=TRUE} in \code{-q}, and so on). Parameters
  with additional input are supposed to be character or numeric vectors,
  where the individual vector elements are collapsed into a single
  comma-separated string (e.g., \code{k=2} is translated into \code{k
  2}, \code{bmax=100} into \code{--bmax 100}, \code{3=letters[c(1,2,3)]} into
  \code{-3 a,b,c}, and so on). Note that some arguments to the bowtie
  binary will be ignored if they are already handled as explicit
  function arguments. See the output of \code{bowtie_usage()} and
  \code{bowtie_build_usage()} for details about available parameters.
  
}


\value{
  The output generated by calling the binaries. For \code{bowtie_build}
  this is typically a report of the index generation, for
  \code{bowtie} this can be a vector of aligments (if \code{outfile} is
  missing), otherwise an empty character scalar.

  \code{bowtie_usage()} and \code{bowtie_build_usage()} return the usage
  information for the respective binaries.
  
  \code{bowtie_version()} return the bowtie versions information.
}

\references{
    Langmead B, Trapnell C, Pop M, Salzberg SL. \emph{Ultrafast and
      memory-efficient alignment of short DNA sequences to the human
      genome.} Genome Biology 10:R25.
  
    Langmead B, Schatz M, Lin J, Pop M, Salzberg SL. \emph{Searching for
      SNPs with cloud computing}. Genome Biology 10:R134.
        
}

\author{
Florian Hahne
}

\examples{
td <- tempdir()

## Building a bowtie index
refs <- dir(system.file(package="Rbowtie", "samples", "refs"),
full=TRUE)
tmp <- bowtie_build(references=refs, outdir=file.path(td, "index"),
force=TRUE)
head(tmp)
dir(file.path(td, "index"))
tmp2 <- bowtie_build(references=refs, outdir=file.path(td,"indexColor"),
force=TRUE, C=TRUE)
dir(file.path(td, "indexColor"))
head(tmp2)


## Alignments
reads <- system.file(package="Rbowtie", "samples", "reads", "reads.fastq")
tmp <- bowtie(sequences=reads, index=file.path(td, "index", "index"))
tmp
bowtie(sequences=reads, index=file.path(td, "index", "index"),
outfile=file.path(td, "alignments.txt"), best=TRUE, force=TRUE)
readLines(file.path(td, "alignments.txt"))

bowtie(sequences=list("TGGGTGGGGTATTCTAGAAATTTCTATTAATCCT",
                      "TCTGTTCAAGTCAGATGGTCACCAATCTGAAGAC"),
index=file.path(td, "index", "index"), type="paired", c=TRUE)
}

\keyword{programming}

