% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZarrArray-class.R
\docType{class}
\name{ZarrArray-class}
\alias{ZarrArray-class}
\alias{matrixClass,ZarrArray-method}
\alias{chunkdim,ZarrArraySeed-method}
\alias{ZarrMatrix}
\alias{ZarrMatrix-class}
\alias{coerce}
\alias{coerce,ZarrArray,ZarrMatrix-method}
\alias{coerce,ZarrMatrix,ZarrArray-method}
\alias{coerce,ANY,ZarrMatrix-method}
\alias{ZarrArray}
\alias{ZarrArray-method}
\title{ZarrArray constructor}
\usage{
ZarrArray(zarr_array_path)
}
\arguments{
\item{zarr_array_path}{Path to a Zarr array. A character vector of length 1.
This can either be a location on a local file system or the URI to an array
in S3 storage.}
}
\value{
Object of class \code{ZarrArray}
}
\description{
\code{ZarrayArray}: function to create a new object of class \code{ZarrArray}.
}
\examples{
zarr_example <- system.file(
  "extdata", "zarr_examples", "column-first", "int32.zarr",
  package = "Rarr"
)
zarr_array <- ZarrArray(zarr_example)
is(zarr_array)
dim(zarr_array)
chunkdim(zarr_array)
}
