% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monteCarloMethods.R
\name{monteCarloSharingProb}
\alias{monteCarloSharingProb}
\title{calculates sharing probability by simulating pedigree outcomes}
\usage{
monteCarloSharingProb(
  procPed,
  alleleFreq = NA,
  kinshipCoeff = NA,
  nSim,
  founderDist = NULL,
  kinshipOrder = 5
)
}
\arguments{
\item{procPed}{pedigree that has been through \code{processPedigree}}

\item{alleleFreq}{allele frequency among the founders}

\item{kinshipCoeff}{mean kinship coefficient among the founders}

\item{nSim}{number of simulations used in monte carlo calculation}

\item{founderDist}{custom distribution among founders. Only used
when simulating probability with nSim}

\item{kinshipOrder}{order of the polynomial approximation to the distribtion
of the number of distinct alleles in the founders (d in Bureau et al.).
Must be <= 5}
}
\value{
sharing probability between all carriers in pedigree
}
\description{
Calculates the same exact probability as RVsharing,
except uses monte carlo simulation instead of exact computation.
This method allows for more flexibility in the scenarios considered.
}
\keyword{internal}
