% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVsharing.R
\docType{methods}
\name{RVsharing}
\alias{RVsharing}
\alias{RVsharing,pedigree-method}
\alias{RVsharing,list-method}
\title{probability of sharing a rare variant among relatives}
\usage{
RVsharing(
  ped,
  carriers = NULL,
  alleleFreq = NA,
  kinshipCoeff = NA,
  nSim = NA,
  founderDist = NULL,
  useAffected = FALSE,
  kinshipOrder = 5,
  splitPed = FALSE,
  useFounderCouples = TRUE,
  ...
)

\S4method{RVsharing}{pedigree}(
  ped,
  carriers = NULL,
  alleleFreq = NA,
  kinshipCoeff = NA,
  nSim = NA,
  founderDist = NULL,
  useAffected = FALSE,
  kinshipOrder = 5,
  splitPed = FALSE,
  useFounderCouples = TRUE,
  ...
)

\S4method{RVsharing}{list}(
  ped,
  carriers = NULL,
  alleleFreq = NA,
  kinshipCoeff = NA,
  nSim = NA,
  founderDist = NULL,
  useAffected = FALSE,
  kinshipOrder = 5,
  splitPed = FALSE,
  useFounderCouples = TRUE,
  ...
)
}
\arguments{
\item{ped}{S3 pedigree object or a list of pedigree objects}

\item{carriers}{subjects in pedigree that have the variant, if
ped is a list, then this will also be a list of vectors specifying
the carriers in each pedigree}

\item{alleleFreq}{allele frequency among the founders}

\item{kinshipCoeff}{mean kinship coefficient among the founders}

\item{nSim}{number of simulations used in monte carlo calculation}

\item{founderDist}{custom distribution among founders. Only used
when simulating probability with nSim}

\item{useAffected}{a logical value indicating whether to condition on seeing the variant
among the affected subjects instead of the final descendants}

\item{kinshipOrder}{order of the polynomial approximation to the distribtion
of the number of distinct alleles in the founders (d in Bureau et al.).
Must be <= 5}

\item{splitPed}{a logical value indicating whether to split the pedigree in subpedigrees below each founder to enable computations in pedigrees too large to be stored in a single Bayesian network}

\item{useFounderCouples}{a logical value indicating whether to exploit the interchangeability of the mother and father from founder couples to save computations. Warning! This works only when all founders have only one spouse. Set to FALSE if at least one founder has two or more spouses. Only used when splitPed = TRUE}

\item{...}{allows for additional arguments}
}
\value{
sharing probability between all carriers in pedigree, or if splitPed = TRUE, a vector of sharing probabilities for all subsets of the carriers
}
\description{
computing probability that a rare variant is shared by a
set of subjects in a pedigree using the gRain package
}
\details{
the function RVsharing computes the probability that all subjects
identified as carriers of a rare variant in the vector carriers
(or all final descendants in the pedigree if carriers == NULL) share that
rare variant AND the final descendants not included in carriers do not
carry it, given that the rare variant has been detected in any subject
in the union of the carriers and the final descendants of the pedigree.
A final descendant is defined as a subject without descendant in the
pedigree, it it not necessarily in the youngest generation. If carriers
enumerates a subset of pedigree members, the function will then compute
the probability these carriers share the rare variant AND the final
descendants not included in carriers do not carry it based on the above
terms. To obtain the probability that a set of pedigree members carry a
rare variant given it was seen in any of the set members (ignoring the
carrier status of final descendants not in the set), the pedigree must be
trimmed of the other final descendants before calling RVsharing.
}
\examples{
data("samplePedigrees")
RVsharing(samplePedigrees$firstCousinPair)
}
\references{
Bureau, A., Younkin, S., Parker, M.M., Bailey-Wilson, J.E.,
Marazita, M.L., Murray, J.C., Mangold, E., Albacha-Hejazi, H., Beaty, T.H.
and Ruczinski, I. (2014) Inferring rare disease risk variants based on
exact probabilities of sharing by multiple affected relatives.
Bioinformatics, 30(15): 2189-96, doi:10.1093/bioinformatics/btu198.

Sherman, T., Fu, J., Scharpf, R., Bureau, A., and Ruczinski, I. (2018)
Detection of rare disease variants in extended pedigrees using RVS.
Bioinformatics, 1-3, doi: 10.1093/bioinformatics/bty976
}
