% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tnsSRE.R
\docType{methods}
\name{tnsSRE,TNS-method}
\alias{tnsSRE,TNS-method}
\alias{tnsSRE}
\title{Subgroup Regulon Enrichment for TNS-class objects}
\usage{
\S4method{tnsSRE}{TNS}(tns, subgroup, regs = NULL, pValueCutoff = 0.05, pAdjustMethod = "BH")
}
\arguments{
\item{tns}{A A \linkS4class{TNS} object.}

\item{subgroup}{a character vector. It must be the name of a column in the
survivalData featuring the grouping information as a categorical variable.}

\item{regs}{An optional string vector specifying regulons to use for the analysis.}

\item{pValueCutoff}{a single numeric value specifying the cutoff for 
p-values considered significant.}

\item{pAdjustMethod}{a single character value specifying the p-value 
adjustment method to be used (see 'p.adjust' for details).}
}
\value{
A TNS-class object with the results of the subgroup regulon enrichment
added to the results slot. To recover the results, use tnsGet(tns, "regulonEnrichment")
}
\description{
This method evaluates which regulons are enriched in sample groups, given a
grouping variable. It performs Fisher's Exact Test whether a regulon is
positively or negatively enriched in a subgroup using regulon activity.
}
\examples{
# load survival data
data(survival.data)
# load TNI-object
data(stni, package = "RTN")

# create TNS object
stns <- tni2tnsPreprocess(stni, survivalData = survival.data,
                          keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)

# run subgroup regulon enrichment analysis
stns <- tnsSRE(stns, "ER+")

# plot the result
tnsPlotSRE(stns)
}
