% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsPlotKM,TNS-method}
\alias{tnsPlotKM,TNS-method}
\alias{tnsPlotKM}
\title{Kaplan-Meier plots for TNS class objects}
\usage{
\S4method{tnsPlotKM}{TNS}(
  tns,
  regs = NULL,
  attribs = NULL,
  pValueCutoff = 1,
  fname = "survplot",
  fpath = ".",
  xlab = "Months",
  ylab = "Survival probability",
  colorPalette = "bluered",
  plotpdf = FALSE,
  plotbatch = FALSE,
  width = 6.3,
  height = 3.6,
  panelWidths = c(3, 2, 2, 4)
)
}
\arguments{
\item{tns}{A \linkS4class{TNS} object, which must have passed GSEA2 analysis.}

\item{regs}{An optional string vector specifying regulons to make the plot.}

\item{attribs}{A character vector of attributes listed in the column 
names of the survivalData. All attributes should be binary encoded for
plotting. Available attributes can be checked by running 
colnames(tnsGet(tns, "survivalData")). Alternatively, attributes
can be grouped when provided within a list.}

\item{pValueCutoff}{A numeric value in [0,1]. The p-value cutoff applied to 
the results from the KM analysis pipeline.}

\item{fname}{A string. The name of the file in which the plot will be saved}

\item{fpath}{A string. The path to the directory where the plot will be saved}

\item{xlab}{A string. The label for the x axis on the third panel. This should
be the measure of time shown in the survival data frame after the last 
check-up.}

\item{ylab}{A string. The label for the y axis on the third panel}

\item{colorPalette}{A string, which can be 'redblue' or 'bluered'. 
Alternatively, it can be colors or hex values.}

\item{plotpdf}{A logical value. If TRUE, the plot is saved as a pdf file. 
If false, it is plotted in the plotting area.}

\item{plotbatch}{A logical value. If TRUE, plots for all regulons are saved in 
the same file. If FALSE, each plot for each regulon is saved in a different file.}

\item{width}{A numeric value. Represents the width of the plot.}

\item{height}{A numeric value. Represents the height of the plot.}

\item{panelWidths}{A numeric vector of length=3 specifying the relative 
width of the internal panels.}
}
\value{
A plot, showing a graphical analysis for the 'tnsKM' function.
}
\description{
Plot results from the 'tnsKM' function. The 'tnsPlotKM' function makes 
a 2 or 3 panel plot for survival analysis. The first panel shows the
differential Enrichment score (dES) for all samples, ranked by dES 
in their sections. The second (optional) panel shows the status of other 
attributes which may be present in the survival data frame for all samples. 
The third panel shows a Kaplan-Meier plot computed for the given survival 
data, with a curve for each section.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
        keycovar = c('Grade','Age'), time = 1, event = 2)
stns <- tnsGSEA2(stns)
stns <- tnsKM(stns)
tnsPlotKM(stns)

}
