% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllMethods.R
\docType{methods}
\name{tnsAREA3,TNS-method}
\alias{tnsAREA3,TNS-method}
\alias{tnsAREA3}
\title{Compute regulon activity by calling aREA (analytic Rank-based Enrichment Analysis) algorithm}
\usage{
\S4method{tnsAREA3}{TNS}(tns, ...)
}
\arguments{
\item{tns}{A \linkS4class{TNS} class, which has been preprocessed}

\item{...}{Additional parameters passed to \code{\link{tni.area3}} function.}
}
\value{
A \linkS4class{TNS} class, with added regulon activity scores.
}
\description{
Uses \code{\link{tni.area3}} function to compute regulon activity
for \linkS4class{TNS} class objects.
}
\examples{
# load survival data
data(survival.data, package = "RTNsurvival")

# load TNI-object
data(stni, package = "RTN")

stns <- tni2tnsPreprocess(stni, survivalData = survival.data, 
keycovar = c('Grade','Age'), time = 1, event = 2)

stns <- tnsAREA3(stns)

}
\references{
Alvarez et al. Functional characterization of somatic mutations in cancer
using network-based inference of protein activity. Nature Genetics, 48(8):838-847, 2016.
}
\seealso{
\code{\link{tni.area3}} for additional details.
}
