% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllPlotsMBR.R
\name{mbrPlotDuals}
\alias{mbrPlotDuals}
\title{Plot shared targets between regulons.}
\usage{
mbrPlotDuals(
  object,
  dualreg,
  filepath = NULL,
  cols = c("#006400FF", "#CD6600FF")
)
}
\arguments{
\item{object}{A processed object of class \linkS4class{MBR} evaluated by 
the method \code{\link{mbrAssociation}}.}

\item{dualreg}{A string indicating the name of a dual regulon.}

\item{filepath}{A string indicating the file path where the plot 
should be saved.}

\item{cols}{A vector of length 2 indicating a diverging color scheme 
for negative and positive correlations, respectively.}
}
\value{
A plot showing targets of dual regulons.
}
\description{
This function plots the shared targets for a regulon pair.
}
\examples{

##--- load a dataset for demonstration
data("tniData", package = "RTN")
gexp <- tniData$expData
annot <- tniData$rowAnnotation
tfs <- c("IRF8","IRF1","PRDM1","E2F3","STAT4","LMO4","ZNF552")

##--- construct a tni object
rtni <- tni.constructor(gexp, regulatoryElements = tfs, rowAnnotation=annot)

##--- compute regulons 
## set nPermutations>=1000
rtni <- tni.permutation(rtni, nPermutations=30)
## set nBootstrap>=100
rtni <- tni.bootstrap(rtni, nBootstrap=30)
## 'eps=NA' estimates threshold from empirical null
rtni <- tni.dpi.filter(rtni, eps=NA)

##--- construct a mbr object
rmbr <- tni2mbrPreprocess(rtni)

##--- run mbrAssociation 
## set nPermutations>=1000
rmbr <- mbrAssociation(rmbr, pValueCutoff = 0.05, nPermutations=30)

\dontrun{

##--- get inferred duals and plot the shared cloud of targets
duals <- mbrGet(rmbr, what="dualRegulons")
mbrPlotDuals(rmbr, dualreg=duals[1])

}
}
