% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaTCGA.R
\name{pcaTCGA}
\alias{pcaTCGA}
\title{Plot Two Main Components of Principal Component Analysis}
\usage{
pcaTCGA(
  x,
  group.names,
  title = "",
  return.pca = FALSE,
  scale = TRUE,
  center = TRUE,
  var.scale = 1,
  obs.scale = 1,
  ellipse = TRUE,
  circle = TRUE,
  var.axes = FALSE,
  alpha = 0.8,
  add.lines = TRUE,
  ggtheme = theme_RTCGA(),
  ...
)
}
\arguments{
\item{x}{A \code{data.frame} or \code{matrix} containing i.e. expressions information. See \link{expressionsTCGA}.}

\item{group.names}{Names of group variable to use in labels of the plot.}

\item{title}{The title of a plot.}

\item{return.pca}{Should return pca object additionaly to pca plot?}

\item{scale}{As in \link{prcomp}.}

\item{center}{As in \link{prcomp}.}

\item{var.scale}{As in \code{ggbiplot}.}

\item{obs.scale}{As in \code{ggbiplot}.}

\item{ellipse}{As in \code{ggbiplot}.}

\item{circle}{As in \code{ggbiplot}.}

\item{var.axes}{As in \code{ggbiplot}.}

\item{alpha}{As in \code{ggbiplot}.}

\item{add.lines}{Should axis lines be added to plot.}

\item{ggtheme}{a \code{ggtheme} to be used (set to \code{NULL}, if using \pkg{ggthemr} package)}

\item{...}{Further arguments passed to \link{prcomp}.}
}
\value{
If \code{return.pca = TRUE} then a list containing a PCA plot (of class \code{ggplot}) and a \code{pca} model, the result of \link{prcomp} function.
If not, then only PCA plot is returned.
}
\description{
Plots Two Main Components of Principal Component Analysis
}
\section{ggbiplot}{


This function is based on \href{https://github.com/vqv/ggbiplot}{https://github.com/vqv/ggbiplot} 
which had to be copied to \pkg{RTCGA} because \code{Bioconductor} does not support 
remote dependencies from \code{GitHub}.
}

\section{Issues}{


If you have any problems, issues or think that something is missing or is not
clear please post an issue on 
\href{https://github.com/RTCGA/RTCGA/issues}{https://github.com/RTCGA/RTCGA/issues}.
}

\examples{

\dontrun{
library(dplyr)
## RNASeq expressions
library(RTCGA.rnaseq)
expressionsTCGA(BRCA.rnaseq, OV.rnaseq, HNSC.rnaseq) \%>\%
  rename(cohort = dataset) \%>\%  
  filter(substr(bcr_patient_barcode, 14, 15) == "01") -> BRCA.OV.HNSC.rnaseq.cancer

pcaTCGA(BRCA.OV.HNSC.rnaseq.cancer, "cohort")
pcaTCGA(BRCA.OV.HNSC.rnaseq.cancer, "cohort", add.lines = FALSE)
pcaTCGA(BRCA.OV.HNSC.rnaseq.cancer, "cohort", return.pca = TRUE) -> pca.rnaseq
pca.rnaseq$plot
pca.rnaseq$pca
}

}
\seealso{
\pkg{RTCGA} website \href{http://rtcga.github.io/RTCGA/articles/Visualizations.html}{http://rtcga.github.io/RTCGA/articles/Visualizations.html}.

Other RTCGA: 
\code{\link{RTCGA-package}},
\code{\link{boxplotTCGA}()},
\code{\link{checkTCGA}()},
\code{\link{convertTCGA}()},
\code{\link{datasetsTCGA}},
\code{\link{downloadTCGA}()},
\code{\link{expressionsTCGA}()},
\code{\link{heatmapTCGA}()},
\code{\link{infoTCGA}()},
\code{\link{installTCGA}()},
\code{\link{kmTCGA}()},
\code{\link{mutationsTCGA}()},
\code{\link{readTCGA}()},
\code{\link{survivalTCGA}()},
\code{\link{theme_RTCGA}()}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{RTCGA}
