% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAsense.R
\name{plotSSGS}
\alias{plotSSGS}
\title{plot SSGS gene classes}
\usage{
plotSSGS(myresultCombined = resultCombined, mytimes = times,
  myanalyzeConditions = analyzeConditions)
}
\arguments{
\item{myresultCombined}{data.frame, output of \link{combineResults}}

\item{mytimes}{Numeric vector, Time points of the time-resolved RNA-seq data}

\item{myanalyzeConditions}{character vector, the conditions that were analyzed}
}
\value{
SSGS color plot in ggplot format
}
\description{
Genes are sorted into groups with respect to switch time and time point of fold change detection. For each group, results of wild type and knockdown-condition are compared by means of fisher's exact test to show whether the knocked down gene enhances or suppresses the respective gene group.
}
\examples{
library(ggplot2)
data(MZsox)
mydata <- MZsox[seq(1,nrow(MZsox), by=10),]
resultFC <- getFC(dataset = mydata,
myanalyzeConditions = c("WT", "MZsox"),
cores = 1,
mytimes = c(2.5,3,3.5,4,4.5,5,5.5,6))
resultSwitch <- getSwitch(dataset = mydata,
experimentStepDetection = "WT",
cores = 1,
mytimes = c(2.5,3,3.5,4,4.5,5,5.5,6))
resultCombined <- combineResults(resultSwitch, resultFC)
plotSSGS(myresultCombined = resultCombined,
mytimes = c(2.5,3,3.5,4,4.5,5,5.5,6),
myanalyzeConditions = c("WT", "MZsox"))
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}
