% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ModifierML-class.R
\docType{class}
\name{setMLModel<-}
\alias{setMLModel<-}
\alias{getMLModel}
\alias{hasMLModel}
\alias{useMLModel}
\alias{ModifierML-class}
\alias{ModifierML}
\alias{setMLModel<-,ModifierML-method}
\alias{getMLModel,ModifierML-method}
\alias{hasMLModel,ModifierML-method}
\alias{aggregate,ModifierML-method}
\alias{useMLModel,ModifierML-method}
\alias{modify,ModifierML-method}
\alias{RNAModifierML-class}
\alias{DNAModifierML-class}
\title{The ModifierML class}
\usage{
setMLModel(x) <- value

getMLModel(x)

hasMLModel(x)

useMLModel(x)

\S4method{setMLModel}{ModifierML}(x) <- value

\S4method{getMLModel}{ModifierML}(x)

\S4method{hasMLModel}{ModifierML}(x)

\S4method{aggregate}{ModifierML}(x, force = FALSE)

\S4method{useMLModel}{ModifierML}(x)

\S4method{modify}{ModifierML}(x, force = FALSE)
}
\arguments{
\item{x}{a \code{ModifierML} object.}

\item{value}{a \code{ModifierMLModel} object}

\item{force}{whether to recreate the aggregated data, if it is already stored
inside the \code{Modifier} object.}
}
\value{
a \code{ModifierML} object
}
\description{
The \code{ModifierML} class is a virtual class, which provides the central
functionality for searching with a machine learning models for patterns of
post-transcriptional RNA modifications in high throughput sequencing data.

It extends the virtual \code{Modifier} class form the \code{RNAmodR} package
and add the \code{useMLModel} function. If not called directly for a
\code{ModifierML} class, the \code{useMLModel} will be called from the
\code{aggregate} function.

The slot \code{mlModel} is added and serves a dual purpose. If \code{mlModel}
is a character, a class of the type \code{ModifierMLModel} is created upon
creation of a \code{ModifierML} object. However, for developing purposes
the slot can also remain empty and a \code{ModifierMLModel} object can be set
using the \code{setMLModel} function and retrieved using the
\code{getMLModel}. If the \code{mlModel} slot is empty, the \code{findMod}
setting will be set to \code{FALSE} and the \code{ModifierML} object will
be returned just with the aggregate data. Such an object can then be used to
train a machine learning model. The data can be accessed using
\code{\link{trainingData}}.
}
\section{Slots}{

\describe{
\item{\code{mlModel}}{a \code{character} describing a class name for creating a
\code{ModifierMLModel} object or a \code{ModifierMLModel} object itself.
If \code{mlModel} is a \code{character}, the class will tried to be create
by calling a function of the same name.}
}}

\examples{
# an example implementation of a ModifierML object
setClass("ModMLExample",
         contains = c("RNAModifierML"),
         prototype = list(mod = c("D"),
                          score = "score",
                          dataType = c("PileupSequenceData",
                                       "CoverageSequenceData"),
                          mlModel = character(0)))
# constructor function for ModMLExample
ModMLExample <- function(x, annotation = NA, sequences = NA, seqinfo = NA,
                         ...){
  RNAmodR:::Modifier("ModMLExample", x = x, annotation = annotation,
                     sequences = sequences, seqinfo = seqinfo, ...)
}
}
\seealso{
\code{\link[RNAmodR:Modifier-class]{Modifier}}
}
