% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modifier-AlkAnilineSeq-class.R,
%   R/Modifier-AlkAnilineSeq-viz.R
\name{ModAlkAnilineSeq-functions}
\alias{ModAlkAnilineSeq-functions}
\alias{aggregate}
\alias{modify}
\alias{settings}
\alias{plotData}
\alias{plotDataByCoord}
\alias{settings<-,ModAlkAnilineSeq-method}
\alias{aggregateData,ModAlkAnilineSeq-method}
\alias{findMod,ModAlkAnilineSeq-method}
\alias{getDataTrack,ModAlkAnilineSeq-method}
\alias{plotDataByCoord,ModAlkAnilineSeq,GRanges-method}
\alias{plotData,ModAlkAnilineSeq-method}
\alias{plotDataByCoord,ModSetAlkAnilineSeq,GRanges-method}
\alias{plotData,ModSetAlkAnilineSeq-method}
\title{Functions for ModAlkAnilineSeq}
\usage{
\S4method{settings}{ModAlkAnilineSeq}(x) <- value

\S4method{aggregateData}{ModAlkAnilineSeq}(x)

\S4method{findMod}{ModAlkAnilineSeq}(x)

\S4method{getDataTrack}{ModAlkAnilineSeq}(x, name, type, ...)

\S4method{plotDataByCoord}{ModAlkAnilineSeq,GRanges}(
  x,
  coord,
  type = c("ends", "scoreNC", "scoreSR"),
  window.size = 15L,
  ...
)

\S4method{plotData}{ModAlkAnilineSeq}(
  x,
  name,
  from = 1L,
  to = 30L,
  type = c("ends", "scoreNC", "scoreSR"),
  ...
)

\S4method{plotDataByCoord}{ModSetAlkAnilineSeq,GRanges}(
  x,
  coord,
  type = c("scoreNC", "scoreSR", "ends"),
  window.size = 15L,
  ...
)

\S4method{plotData}{ModSetAlkAnilineSeq}(
  x,
  name,
  from = 1L,
  to = 30L,
  type = c("scoreNC", "scoreSR", "ends"),
  ...
)
}
\arguments{
\item{x}{a \code{\link[RNAmodR:Modifier-class]{Modifier}} or a
\code{\link[RNAmodR:ModifierSet-class]{ModifierSet}} object. For more
details see also the man pages for the functions mentioned below.}

\item{value}{See \code{\link[RNAmodR:Modifier-class]{settings}}}

\item{coord, name, from, to, type, window.size, ...}{See 
\code{\link[RNAmodR:plotData]{plotData}}.}
}
\value{
\itemize{
\item \code{settings}: See 
\code{\link[RNAmodR:Modifier-functions]{settings}}.
\item \code{aggregate}: See \code{\link[RNAmodR:aggregate]{aggregate}}.
\item \code{modify}: See \code{\link[RNAmodR:modify]{modify}}.
\item \code{getDataTrack}: a list of 
\code{\link[Gviz:DataTrack-class]{DataTrack}} object.
\item \code{plotData}: See 
\code{\link[RNAmodR:plotData]{plotDataByCoord}}.
\item \code{plotDataByCoord}: See 
\code{\link[RNAmodR:plotData]{plotDataByCoord}}.
}
}
\description{
All of the functions of \code{\link[RNAmodR:Modifier-class]{Modifier}} and
the \code{\link[RNAmodR:ModifierSet-class]{ModifierSet}} classes are
inherited by the \code{ModAlkAnilineSeq} and \code{ModSetAlkAnilineSeq}
classes.
}
\details{
\code{ModAlkAnilineSeq} specific arguments for \link{plotData}:
\itemize{
\item \code{colour} - a named character vector of \code{length = 4} 
for the colours of the individual histograms. The names are expected to be 
\code{c("scoreNC","scoreSR")}
}
}
\examples{
data(msaas,package="RNAmodR.AlkAnilineSeq")
maas <- msaas[[1]]
settings(maas)
aggregate(maas)
modify(maas)
getDataTrack(maas, "1", mainScore(maas))
}
