% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comb_cv.R
\name{comb_cv}
\alias{comb_cv}
\title{combined adjusted coefficient of variation}
\usage{
comb_cv(X, eps = 1e-04)
}
\arguments{
\item{X}{data.frame or matrix of numeric data}

\item{eps}{small value to add to the mean to avoid dividing by 0; defaults to 1e-4}
}
\value{
returns the sum of the coefficients of variation for all columns of \code{X}
}
\description{
Calculates the sum of the column standard devation divided by the sum of the column mean and a small value to avoid dividing by 0 (\code{eps})
}
\examples{
comb_cv( data.frame( test1=rep(0,5), test2=c(0.2,0.3,0.35,0.27,0.21) ) )
}
\keyword{internal}
