% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leMsmsRaw.R
\name{findMsMsHR}
\alias{findMsMsHR}
\alias{findMsMsHR.mass}
\title{Extract MS/MS spectra for specified precursor}
\usage{
findMsMsHR(
  fileName = NULL,
  msRaw = NULL,
  cpdID,
  mode = "pH",
  confirmMode = 0,
  useRtLimit = TRUE,
  ppmFine = getOption("RMassBank")$findMsMsRawSettings$ppmFine,
  mzCoarse = getOption("RMassBank")$findMsMsRawSettings$mzCoarse,
  fillPrecursorScan = getOption("RMassBank")$findMsMsRawSettings$fillPrecursorScan,
  rtMargin = getOption("RMassBank")$rtMargin,
  deprofile = getOption("RMassBank")$deprofile,
  headerCache = NULL,
  peaksCache = NULL,
  enforcePolarity = getOption("RMassBank")$enforcePolarity,
  diaWindows = getOption("RMassBank")$findMsMsRawSettings$diaWindows
)

findMsMsHR.mass(
  msRaw,
  mz,
  limit.coarse,
  limit.fine,
  rtLimits = NA,
  maxCount = NA,
  headerCache = NULL,
  fillPrecursorScan = FALSE,
  deprofile = getOption("RMassBank")$deprofile,
  peaksCache = NULL,
  cpdID = NA,
  polarity = NA,
  diaWindows = getOption("RMassBank")$findMsMsRawSettings$diaWindows
)
}
\arguments{
\item{fileName}{The file to open and search the MS2 spectrum in.}

\item{msRaw}{The opened raw file (mzR file handle) to search the MS2 spectrum in. Specify either this
or \code{fileName}.}

\item{cpdID}{The compound ID in the compound list (see \code{\link{loadList}})
to use for formula lookup. Note: In \\code{findMsMsHR.mass}, this is entirely optional and
used only in case a warning must be displayed; compound lookup is done via mass only.}

\item{mode}{The processing mode (determines which ion/adduct is searched):
\code{"pH", "pNa", "pM", "pNH4", "mH", "mM", "mFA"} for different ions 
([M+H]+, [M+Na]+, [M]+, [M+NH4]+, [M-H]-, [M]-, [M+FA]-).}

\item{confirmMode}{Whether to use the highest-intensity precursor (=0), second-
highest (=1), third-highest (=2)...}

\item{useRtLimit}{Whether to respect retention time limits from the compound list.}

\item{ppmFine}{The limit in ppm to use for fine limit (see below) calculation.}

\item{mzCoarse}{The coarse limit to use for locating potential MS2 scans:
this tolerance is used when finding scans with a suitable precursor
    ion value.}

\item{fillPrecursorScan}{If \code{TRUE}, the precursor scan will be filled from MS1 data.
To be used for data where the precursor scan is not stored in the raw data.}

\item{rtMargin}{The retention time tolerance to use.}

\item{deprofile}{Whether deprofiling should take place, and what method should be
used (cf. \code{\link{deprofile}})}

\item{headerCache}{If present, the complete \code{mzR::header(msRaw)}. Passing
this value is useful if spectra for multiple compounds should be 
extracted from the same mzML file, since it avoids getting the data
freshly from \code{msRaw} for every compound.}

\item{peaksCache}{If present, the complete output of \code{mzR::peaks(msRaw)}. This speeds up the lookup
if multiple compounds should be searched in the same file.}

\item{enforcePolarity}{If TRUE, scans are filtered for the given `mode`'s polarity when
finding the target spectrum.}

\item{diaWindows}{A data frame with columns \code{precursorMz}, \code{mzMin}, \code{mzMax} which specifies the precursor and 
window size of each window for DIA acquisition.}

\item{mz}{The mass to use for spectrum search.}

\item{limit.coarse}{Parameter in \code{findMsMsHR.mass} corresponding to \code{mzCoarse}.
(The parameters are distinct to clearly conceptually distinguish findMsMsHR.mass
(a standalone useful function) from the cpdID based functions (workflow functions).)}

\item{limit.fine}{The fine limit to use for locating MS2 scans: this tolerance
is used when locating an appropriate analyte peak in the MS1 precursor
spectrum.}

\item{rtLimits}{\code{c(min, max)}: Minimum and maximum retention time to use
when locating the MS2 scans.}

\item{maxCount}{The maximal number of spectra groups to return. One spectra group
consists of all data-dependent scans from the same precursor whose precursor
mass matches the specified search mass.}

\item{polarity}{If set (for ?findMsMsHR.mass), scans are filtered for the given `mode`'s polarity when
finding the target spectrum.}
}
\value{
An \code{RmbSpectraSet} (for \code{findMsMsHR}). Contains parent MS1 spectrum (\code{@parent}), a block of dependent MS2 spectra ((\code{@children})
			and some metadata (\code{id},\code{mz},\code{name},\code{mode} in which the spectrum was acquired.

			For \code{findMsMsHR.mass}: a list of \code{RmbSpectraSet}s as defined above, sorted
			by decreasing precursor intensity.
}
\description{
Extracts MS/MS spectra from LC-MS raw data for a specified precursor, specified
either via the RMassBank compound list (see \code{\link{loadList}}) or via a mass.
}
\details{
Different versions of the function get the data from different sources. Note that 
		findMsMsHR and findMsMsHR.direct differ mainly in that findMsMsHR opens a file
		whereas findMsMs.direct uses an open file handle - both are intended to be used
		in a full process which involves compound lists etc. In contrast, findMsMsHR.mass
		is a low-level function which uses the mass directly for lookup and is intended for
		use as a standalone function in unrelated applications.
}
\section{Functions}{
\itemize{
\item \code{findMsMsHR.mass()}: A submethod of find MsMsHR that retrieves basic spectrum data

}}
\note{
\code{findMsMs.direct} is deactivated
}
\examples{
\dontrun{
			loadList("mycompoundlist.csv")
			# if Atrazine has compound ID 1:
			msms_atrazine <- findMsMsHR(fileName = "Atrazine_0001_pos.mzML", cpdID = 1, mode = "pH")
			# Or alternatively:
			msRaw <- openMSfile("Atrazine_0001_pos.mzML")
			msms_atrazine <- findMsMsHR(msRaw=msRaw, cpdID = 1, mode = "pH")
			# Or directly by mass (this will return a list of spectra sets):
			mz <- findMz(1)$mzCenter
			msms_atrazine_all <- findMsMsHR.mass(msRaw, mz, 1, ppm(msRaw, 10, p=TRUE))
			msms_atrazine <- msms_atrazine_all[[1]]
}
}
\seealso{
findEIC
}
\author{
Michael A. Stravs, Eawag <michael.stravs@eawag.ch>
}
