% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMassBank.R
\name{exportMassbank}
\alias{exportMassbank}
\title{Export internally stored MassBank data to files}
\usage{
exportMassbank(compiled, molfile = NULL)
}
\arguments{
\item{compiled}{\code{RmbSpectraSet}
the spectra of one compound for which files should be exported}

\item{molfile}{A molfile from \code{\link{createMolfile}}; 
deprecated since molfiles are not used by MassBank anymore.}
}
\value{
No return value.
}
\description{
Exports MassBank recfile data arrays and corresponding molfiles to physical
files on hard disk, for one compound.
}
\details{
The data from \code{compiled} is still used here, because it contains the
"visible" accession number. In the plain-text format contained in
\code{files}, the accession number is not "accessible" anymore since it's in
the file.
}
\note{
An improvement would be to write the accession numbers into
\code{names(compiled)} and later into \code{names(files)} so \code{compiled}
wouldn't be needed here anymore. (The compound ID would have to go into
\code{names(molfile)}, since it is also retrieved from \code{compiled}.)
}
\references{
MassBank record format:
\url{http://www.massbank.jp/manuals/MassBankRecord_en.pdf}
}
\seealso{
\code{\link{createMolfile}}, \code{\link{toMassbank}},
\code{\link{mbWorkflow}}
}
\author{
Michael Stravs
}
