% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{validateSegmentationParameters}
\alias{validateSegmentationParameters}
\title{Parameters validation for the \code{\link{segmentation}} function}
\usage{
validateSegmentationParameters(reads, zeta = 147, delta, maxLength)
}
\arguments{
\item{reads}{a \code{GRanges}, the reads that need to be segmented.}

\item{zeta}{a positive \code{integer} or \code{numeric}, the length
of the nucleosomes. Default: 147.}

\item{delta}{a positive \code{integer} or \code{numeric}, the accepted
range of overlapping section between segments. The overlapping section
being \code{zeta} + \code{delta}.}

\item{maxLength}{a positive \code{integer} or \code{numeric}, the
length of each segment.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{segmentation}} function.
}
\examples{

## Load synthetic dataset of reads
data(syntheticNucleosomeReads)

## Use dataset of reads to create GRanges object
sampleGRanges <- GRanges(seqnames = syntheticNucleosomeReads$dataIP$chr,
ranges = IRanges(start = syntheticNucleosomeReads$dataIP$start,
end = syntheticNucleosomeReads$dataIP$end),
strand = syntheticNucleosomeReads$dataIP$strand)

## The function returns 0 when all parameters are valid
RJMCMCNucleosomes:::validateSegmentationParameters(reads = sampleGRanges,
zeta = 147, delta = 30, maxLength = 12000)

## The function raises an error when at least one paramater is not valid
#\dontrun{RJMCMCNucleosomes:::validateSegmentationParameters(
#reads = c(100), zeta = 147, delta = 30, maxLength = 12000)}

#\dontrun{RJMCMCNucleosomes:::validateSegmentationParameters(
#reads = sampleGRanges, zeta = "hi", delta = 30, maxLength = 12000)}

}
\author{
Astrid Deschenes, Pascal Belleau
}
\keyword{internal}
