% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{validateRDSFilesParameters}
\alias{validateRDSFilesParameters}
\title{Parameters validation for the \code{\link{mergeRDSFiles}}
function}
\usage{
validateRDSFilesParameters(RDSFiles)
}
\arguments{
\item{RDSFiles}{a \code{array}, the names of all RDS used to merge
nucleosome information. The files must contain R object of \code{class}
"rjmcmcNucleosomes" or "rjmcmcNucleosomesMerge".}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validation of all parameters needed by the public
\code{\link{mergeRDSFiles}} function.
}
\examples{

## Loading a file
file_test <- dir(system.file("extdata", package = "RJMCMCNucleosomes"),
pattern = "RJMCMC_seg_02.RDS", full.names = TRUE)

## Testing using a real file
RJMCMCNucleosomes:::validateRDSFilesParameters(file_test)

}
\author{
Astrid Deschenes
}
\keyword{internal}
