% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{term_enrichment}
\alias{term_enrichment}
\title{term_enrichment}
\usage{
term_enrichment(
  geneset,
  resources = resources.default,
  report_resources_separately = FALSE,
  verbose = TRUE,
  all_symbols = NA,
  filter_to_intersection = FALSE,
  ...
)
}
\arguments{
\item{geneset}{vector of gene symbols to be evaluated}

\item{resources}{list containing the reference gene sets to test for enrichment}

\item{report_resources_separately}{logical (default FALSE) flag to report enrichments seperately for each requested resource, or to combine them and produce FDR adjustment across the combined set}

\item{verbose}{print the top results for each annotation resource}

\item{all_symbols}{the background/global set of gene symbols (study dependent; we provide all protien coding genes as a default)}

\item{filter_to_intersection}{[FALSE] should the background and foreground genesets be subsetted to one another?}

\item{...}{further arguments are passed on to enrichment_symbols()}
}
\value{
results matrix of input gene list compared to active gene sets. Q value is calculated within each of the active gene sets.
}
\description{
term_enrichment evaluates the input gene list for enrichment within each of the annotation resources. This differs from the enrichment_symbols function which evaluates the gene list for enrichment against all of the annotation resources grouped together.
}
\examples{
## Check if there is enrichment for any "Hallmark" functions within a input set of genes
require(RITANdata)
myGeneSet <- c('BRCA1','RAD51C','VAV1','HRAS','ABCC1','CYP1B1','CYP3A5')
e <- term_enrichment(myGeneSet, "MSigDB_Hallmarks")
print( e[1:2, -6] )

\dontrun{
term_enrichment(geneset = vac1.day0vs31.de.genes)
term_enrichment(geneset = vac1.day0vs31.de.genes, resources = "MSigDB_Hallmarks")
vac1.day0v31.enrichment <- term_enrichment(geneset = vac1.day0vs31.de.genes, verbose = FALSE)
}
}
