% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/graph2js.R
\name{graph2js}
\alias{graph2js}
\title{Generate the JSON code using D3js that draws A network from Adjacency
matrix and edges, nodes properties.}
\usage{
graph2js(A, innerValues = NULL, innerColors = NULL, innerTexts = NULL,
  starplotValues = NULL, starplotColors = NULL, starplotLabels = NULL,
  starplotTooltips = NULL, starplotUrlLinks = NULL,
  starplotSectorStartedRad = NULL, starplotCircleFillColor = NULL,
  starplotCircleFillOpacity = NULL, nodesGlobal = NULL, nodesProp = NULL,
  edgesGlobal = NULL, edgesProp = NULL, outputDir = NULL,
  filename = NULL, opts = list(), userCssStyles = NULL,
  toolsPar = list(), id = getUUID())
}
\arguments{
\item{A}{signed weighted adjacency \code{matrix} or an instance of the class
\code{graphAM}, \code{graphBAM}, \code{graphNEL} or \code{clusterGraph}
from the graph package}

\item{innerValues}{A \code{matrix} of inner node values to display Barplot
or other component. In a row, numerical values for a node.}

\item{innerColors}{A \code{matrix} of colors for coloring the inner node
barplot or component . In a row, colors values for a node.}

\item{innerTexts}{A \code{matrix} of labels for each bar in inner barplots.
In a row, labels values for a node.}

\item{starplotValues}{A \code{matrix} of [0,1] values for starpot sectors
size}

\item{starplotColors}{A \code{matrix} of hex RGB colors for sectors colors}

\item{starplotLabels}{A \code{matrix} of labels identifying the sectors}

\item{starplotTooltips}{A \code{matrix} of text or even html content for
the sectors tooltips}

\item{starplotUrlLinks}{A \code{matrix} of text for the sectors url links}

\item{starplotSectorStartedRad}{A \code{matrix} with a single column of
[0,2PI] values for the sector start in radians}

\item{starplotCircleFillColor}{A \code{matrix} of hex RGB colors for the
circle background}

\item{starplotCircleFillOpacity}{A \code{matrix} of [0.0,1.0] values for
the background opacity}

\item{nodesGlobal}{A \code{list} of global nodes properties.}

\item{nodesProp}{A \code{data.frame} object containing properties for
specifics nodes width, shape (in 'rect', 'circle', 'lozenge', 'triangle'),
link, tooltip, highlight.X (X from 0 to N for animation) columns}

\item{edgesGlobal}{A \code{list} of global edges properties.}

\item{edgesProp}{A \code{data.frame} object containing properties for
specific edges from, to, width, type, link, color columns}

\item{outputDir}{String that corresponds to the path to a folder or
file where js code and dependencies will be generated. If \code{NULL} is
provided, javascript code is returned in the returned \code{list} by the
function with the slots:
\cr
'jsIncludes' A character string containing JS code for including the
necessary JS files
\cr\cr
'styling' A character string which contains the CSS code for the
GraphRenderer component
\cr\cr
'js' A character string containing the JavaScript code for the rendering
of the data
\cr\cr
'html' A character string containing the HTML code for the rendering of
the component}

\item{filename}{String the name of the result HTML file, a name will be
automatically generated if not provided and by default.}

\item{opts}{\code{list} of options of the GraphRenderer component
(See \code{getDefaultOptions} function available options)}

\item{userCssStyles}{String containing user css styles. (See starplot demo)}

\item{toolsPar}{\code{list} of options for tools attached to GraphRenderer
component. (See \code{getDefaultToolParameters} for details)}

\item{id}{\code{function}, Unique IDs generator, Internal function
getUUID by default.}
}
\value{
A list containing information of the generated js code.
}
\description{
Generate the JSON code using D3js that draws A network from Adjacency
matrix and edges, nodes properties.
}
\examples{
v <- c(0, 0, 1, 1, 0,
       0, 0, 0, 0, 0,
      -1, 0, 0, 1, 0)
a <- matrix(v, 3, 5)
colnames(a) <- LETTERS[1:5]
rownames(a) <- LETTERS[1:3]
g <- graph2js(a)
}

