% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFLOMICS-Methods_05_coexp_analysis.R
\name{runCoExpression}
\alias{runCoExpression}
\alias{runCoExpression,RflomicsSE-method}
\alias{runCoExpression,RflomicsMAE-method}
\alias{getCoExpAnalysesSummary}
\alias{getCoExpAnalysesSummary,RflomicsMAE-method}
\alias{plotCoExpression}
\alias{plotCoExpression,RflomicsSE-method}
\alias{plotCoExpression,RflomicsMAE-method}
\alias{plotCoExpressionProfile}
\alias{plotCoExpressionProfile,RflomicsSE-method}
\alias{plotCoExpressionProfile,RflomicsMAE-method}
\alias{plotCoseqContrasts}
\alias{plotCoseqContrasts,RflomicsSE-method}
\alias{plotCoseqContrasts,RflomicsMAE-method}
\alias{getCoexpSettings}
\alias{getCoexpSettings,RflomicsSE-method}
\alias{getCoexpSettings,RflomicsMAE-method}
\alias{getCoexpClusters}
\alias{getCoexpClusters,RflomicsSE-method}
\alias{getCoexpClusters,RflomicsMAE-method}
\title{Run CoExpression Analysis and process results}
\usage{
\S4method{runCoExpression}{RflomicsSE}(
  object,
  K = 2:20,
  replicates = 5,
  contrastNames = NULL,
  merge = "union",
  model = "Normal",
  GaussianModel = NULL,
  transformation = NULL,
  normFactors = NULL,
  meanFilterCutoff = NULL,
  scale = NULL,
  min.data.size = 100,
  ...
)

\S4method{runCoExpression}{RflomicsMAE}(
  object,
  SE.name,
  K = 2:20,
  replicates = 5,
  contrastNames = NULL,
  merge = "union",
  model = "Normal",
  GaussianModel = NULL,
  transformation = NULL,
  normFactors = NULL,
  meanFilterCutoff = NULL,
  scale = NULL,
  min.data.size = 100,
  ...
)

\S4method{getCoExpAnalysesSummary}{RflomicsMAE}(object, omicNames = NULL)

\S4method{plotCoExpression}{RflomicsSE}(object)

\S4method{plotCoExpression}{RflomicsMAE}(object, SE.name)

\S4method{plotCoExpressionProfile}{RflomicsSE}(
  object,
  cluster = 1,
  condition = "groups",
  features = NULL
)

\S4method{plotCoExpressionProfile}{RflomicsMAE}(
  object,
  SE.name,
  cluster = 1,
  condition = "groups",
  features = NULL
)

\S4method{plotCoseqContrasts}{RflomicsSE}(object)

\S4method{plotCoseqContrasts}{RflomicsMAE}(object, SE.name)

\S4method{getCoexpSettings}{RflomicsSE}(object)

\S4method{getCoexpSettings}{RflomicsMAE}(object, SE.name)

\S4method{getCoexpClusters}{RflomicsSE}(object, clusterName = NULL)

\S4method{getCoexpClusters}{RflomicsMAE}(object, SE.name, clusterName = NULL)
}
\arguments{
\item{object}{An object of class \link{RflomicsSE} or
class \link{RflomicsMAE-class}}

\item{K}{Number of clusters (a single value or a vector of values)}

\item{replicates}{The number of iteration for each K.}

\item{contrastNames}{names of the contrasts from which the DE entities
have to be taken. Can be NULL, in that case every contrasts from the differential
analysis are taken into consideration.}

\item{merge}{\code{"union"} or \code{"intersection"}}

\item{model}{Type of mixture model to use \code{"Poisson"} or
\code{"normal"}. By default, it is the normal.}

\item{GaussianModel}{Type of \code{GaussianModel} to be used for the
Normal mixture model only. This parameters
is set to \code{"Gaussian_pk_Lk_Ck"} by default and doesn't have to
be changed except if an error message proposed
to try another model like \code{"Gaussian_pk_Lk_Bk"}.}

\item{transformation}{The transformation type to be used. By default,
it is the "arcsin" one.}

\item{normFactors}{The type of estimator to be used to normalize for
differences in library size.
By default, it is the "TMM" one.}

\item{meanFilterCutoff}{a cutoff to filter a gene with a mean expression lower than this value.
(only for RNAseq data, set to NULL for others).}

\item{scale}{Boolean. If TRUE scale all variables to unit variance.}

\item{min.data.size}{The minimum allowed number of variables (default: 100)}

\item{...}{Additional arguments.}

\item{SE.name}{SE.name the name of the dataset if the input object
is a \link{RflomicsMAE-class}}

\item{omicNames}{the name of the experiment to summarize.}

\item{cluster}{cluster number}

\item{condition}{Default is group.}

\item{features}{Default is NULL.}

\item{clusterName}{name of the cluster}
}
\value{
An S4 object of class \link{RflomicsSE}
All the results are stored as a named list \code{CoExpAnal}
 in the metadata slot of a given \code{RflomicsSE} object. Objects are:
The runCoExpression method return several results, for \link{coseq}
method, objects are:
\itemize{
\item \code{settings:}  co-expression analysis settings. See \code{getCoexpSetting}
\item \code{results:}  boolean indicating if the co-expression analysis succeed
\itemize{
\item \code{coseqResults:} the raw results of \code{coseq}
\item \code{clusters:}  a List of clusters
\item \code{cluster.nb:}  The number of cluster
\item \code{plots:}  The plots of \code{coseq} results
\item \code{stats:}  A tibble summarizing failed jobs: reason, proportion,
if any
}
\item \code{errors:} error list.
}
}
\description{
This method performs a co-expression/co-abundance analysis of
omic-data.
}
\details{
For now, only the coseq function of the coseq package is used.
For RNAseq data, parameters used are those recommended in DiCoExpress
workflow (see the reference). This parameters are: \code{model="normal"},
\code{transformation="arcsin"}, \code{GaussianModel="Gaussian_pk_Lk_Ck"},
\code{normFactors="TMM"}, \code{meanFilterCutoff = 50}
For proteomics or metabolomics, data are scaled by protein or metabolite
to group them by expression profiles rather than by expression intensity.
After data scaling, recommended parameters (from \code{coseq} developers)
for co-expression analysis are:
\code{model="normal"}, \code{transformation="none"},
\code{GaussianModel="Gaussian_pk_Lk_Ck"},
\code{normFactors="none"},  \code{meanFilterCutoff = NULL}.
}
\section{Accessors}{

A set of getters and setters generic functions to access and
modify objects of the slot metadata of a \link{RflomicsMAE-class} object or
a \link{RflomicsMAE-class} object.


\itemize{
   \item getCoexpSettings: Access to the co-expression analysis settings
   of a given omics dataset
}


\itemize{
   \item getCoexpClusters: get members of a cluster.
 return The list of entities inside this cluster.
}
}

\section{Plots}{

A collection of functions for plotting results from omics analysis steps.


\itemize{
   \item getCoExpAnalysesSummary: ...
}


\itemize{
   \item plotCoExpression:
   list plot of ICL, logLikelihood and coseq object with min ICL
}


\itemize{
   \item plotCoExpressionProfile:
   ...
}


\itemize{
   \item plotCoseqContrasts: This function describes the composition of
   clusters according to the contrast to which the gene belongs
}
}

\examples{
# load ecoseed data
data(ecoseed.mae)

factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

# create rflomicsMAE object with ecoseed data
MAE <- RFLOMICS::createRflomicsMAE(
  projectName = "Tests",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo)

# Set the statistical model and contrasts to test
formulae <- generateModelFormulae(MAE)
MAE <- setModelFormula(MAE, formulae[[1]])  

# Get the contrasts List and choose the first 3 contrasts of type averaged
contrastList <- generateExpressionContrast(MAE, "averaged")

MAE <- setSelectedContrasts(MAE, contrastList = contrastList[c(1, 2, 3),])

# Run the data preprocessing and perform the differential analysis 
MAE <- runDataProcessing(MAE, SE.name = "protetest",  
                         transformMethod = "log2",
                         normMethod = "median")
MAE <- runDiffAnalysis(MAE, SE.name = "protetest")

# Run co-expression analysis
MAE <- runCoExpression(MAE, SE.name = "protetest", 
                       K = 2:5, replicates = 5, 
                       merge = "union")

# get parametres used to run co-expression analysis
coExp.set.list <- getCoexpSettings(MAE[["protetest"]])
coExp.set.list$method

# get results
clusters <- getCoexpClusters(MAE[["protetest"]], clusterName = "cluster_1")

# plots
#plotCoExpression(MAE[["protetest"]])

#plotCoExpressionProfile(MAE[["protetest"]], cluster = 2)

#plotCoseqContrasts(MAE[["protetest"]])
}
\references{
Lambert, I., Paysant-Le Roux, C., Colella, S. et al. DiCoExpress:
a tool to process multifactorial RNAseq experiments from quality controls
to co-expression analysis through differential analysis based on contrasts
inside GLM models. Plant Methods 16, 68 (2020).
}
\seealso{
\code{\link[coseq]{coseq}}

\code{\link{createRflomicsMAE}}

\code{\link{generateModelFormulae}}

\code{\link{generateExpressionContrast}}

\code{\link{runDataProcessing}}

\code{\link{runDiffAnalysis}}
}
