% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecoseed.R
\docType{data}
\name{ecoseed.mae}
\alias{ecoseed.mae}
\title{Ecoseed project data}
\format{
ecoseed.mae: a \link{MultiAssayExperiment} object, of RNAtest, 
   protetest and metatest data in \link{SummarizedExperiment}
   \itemize{
     \item ExperimentList class object of length 3: 
     \itemize{
       \item RNAtest: a \link{SummarizedExperiment} object with RNAseq data,
       \item protetest: a \link{SummarizedExperiment} object with proteomics data,
       \item metatest: a \link{SummarizedExperiment} object with metabolomics data
     }
     \item DataFrame with experiment design
     \item ...
   }
}
\usage{
data("ecoseed.mae")
}
\description{
This dataset is provided by the EcoSeed project (FP7-KBBE; Impacts of 
Environmental Conditions on Seed Quality). that investigates the 
effect of seed production temperature on the germination potential of 
Arabidopsis thaliana.

This dataset is a multi-omics dataset composed of three data matrices:
transcriptomics (raw RNAseq read count data matrix), metabolomics and proteomics
(relative abundance matrix as XIC).

These data are provided in 2 object: ecoseed.df and ecoseed.mae
}
\examples{
data("ecoseed.mae")
}
\references{
FP7-KBBE; Impacts of Environmental Conditions on Seed Quality
}
\keyword{datasets}
