% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{patientsMNVPlot}
\alias{patientsMNVPlot}
\title{patientsMNVPlot}
\usage{
patientsMNVPlot(
  multi_nucleotides_counts,
  samples = rownames(multi_nucleotides_counts),
  freq = FALSE,
  xlabels = FALSE
)
}
\arguments{
\item{multi_nucleotides_counts}{Multi-Nucleotide counts matrix.}

\item{samples}{Name of the samples. This should match a rownames in multi_nucleotides_counts}

\item{freq}{Boolean value; shall I display rates instead of counts?}

\item{xlabels}{Boolean value; shall I display x labels?}
}
\value{
A ggplot2 object.
}
\description{
Plot Multi-Nucleotide Variants (MNVs) counts for a set of given patients.
}
\examples{
data(plot_data_examples)
counts <- plot_data_examples[['patients.MNV.plot']][['counts']]
patientsMNVPlot(multi_nucleotides_counts=counts,samples=rownames(counts)[seq_len(2)])

}
