% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{groupsCNPlot}
\alias{groupsCNPlot}
\title{groupsCNPlot}
\usage{
groupsCNPlot(counts, groups, normalize = TRUE, xlabels = FALSE)
}
\arguments{
\item{counts}{Matrix with Copy Number (CN) counts data.}

\item{groups}{List where names are groups labels and elements are patients labels corresponding to rownames in counts.}

\item{normalize}{Boolean value; shall I normalize observed counts?}

\item{xlabels}{Boolean value; shall I display x labels?}
}
\value{
A ggplot2 object.
}
\description{
Plot observed Copy Number (CN) counts for different groups of patients.
}
\examples{
data(plot_data_examples)
counts <- plot_data_examples[['groups.CN.plot']][['counts']]
groups <- plot_data_examples[['groups.CN.plot']][['groups']]
groupsCNPlot(counts=counts,groups=groups)

}
