% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.import.R
\name{getIDCounts}
\alias{getIDCounts}
\title{getIDCounts}
\usage{
getIDCounts(data, reference = NULL)
}
\arguments{
\item{data}{A data.frame with variants having 6 columns: sample name, chromosome, start position, end position, ref, alt.}

\item{reference}{A BSgenome object with the reference genome to be used.}
}
\value{
A matrix with Small Insertions and Deletions (IDs) counts per patient.
}
\description{
Create Small Insertions and Deletions (IDs) counts matrix from input data.
}
\examples{
library('BSgenome.Hsapiens.1000genomes.hs37d5')
data(id_example_reduced)
res <- getIDCounts(data = id_example_reduced, reference = BSgenome.Hsapiens.1000genomes.hs37d5)

}
