% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{patientsCNPlot}
\alias{patientsCNPlot}
\title{patientsCNPlot}
\usage{
patientsCNPlot(
  cn_data_counts,
  samples = rownames(cn_data_counts),
  freq = FALSE,
  xlabels = FALSE
)
}
\arguments{
\item{cn_data_counts}{Copy Number counts matrix.}

\item{samples}{Name of the samples. This should match a rownames in cn_data_counts}

\item{freq}{Boolean value; shall I display rates instead of counts?}

\item{xlabels}{Boolean value; shall I display x labels?}
}
\value{
A ggplot2 object.
}
\description{
Plot Copy Number (CN) counts for a set of given patients.
}
\examples{
data(plot_data_examples)
counts <- plot_data_examples[['patients.CN.plot']][['counts']]
patientsCNPlot(cn_data_counts=counts,samples=rownames(counts)[seq_len(2)])

}
