% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{remp_options}
\alias{remp_options}
\alias{remp_reset}
\title{Set or get options for REMP package}
\usage{
remp_options(...)

remp_reset()
}
\arguments{
\item{...}{Option names to retrieve option values or \code{[key]=[value]} pairs to set options.}
}
\value{
\code{NULL}
}
\description{
Tools to manage global setting options for REMP package.
}
\section{Supported options}{

The following options are supported
\describe{
 \item{\code{.default.AluFamily.grep}}{Regular expression for 'grep' to extract Alu family to be included in the prediction.}
 \item{\code{.default.L1Family.grep}}{Regular expression for 'grep' to extract L1 family to be included in the prediction.}
 \item{\code{.default.ERVFamily.grep}}{Regular expression for 'grep' to extract ERV family to be included in the prediction.}
 \item{\code{.default.chr}}{List of human chromosome.}
 \item{\code{.default.GM12878.450k.URL}}{URL to download GM12878 450k methylation profiling data.}
 \item{\code{.default.RMSK.hg19.URL}}{URL to download RepeatMasker database in hg19 genome.}
 \item{\code{.default.RMSK.hg38.URL}}{URL to download RepeatMasker database in hg38 genome.}
 \item{\code{.default.refGene.hg19.URL}}{URL to download refSeq gene database in hg19 genome.}
 \item{\code{.default.refGene.hg38.URL}}{URL to download refSeq gene database in hg38 genome.}
 \item{\code{.default.AH.repeatmasker.hg19}}{\code{AnnotationHub} data ID linked to RepeatMasker
 annotation database (Mar 2020, build hg19).}
 \item{\code{.default.AH.repeatmasker.hg38}}{\code{AnnotationHub} data ID linked to RepeatMasker
 annotation database (Sep 2021, build hg38).}
 \item{\code{.default.AH.refgene.hg19}}{\code{AnnotationHub} data ID linked to refSeq gene database
 (build hg19)}
 \item{\code{.default.AH.hg38ToHg19.over.chain}}{\code{AnnotationHub} hg38 to hg19 liftover chain data ID.}
 \item{\code{.default.AH.hg19ToHg38.over.chain}}{\code{AnnotationHub} hg19 to hg38 liftover chain data ID.}
 \item{\code{.default.TSS.upstream}}{Define the upstream range of transcription start site region.}
 \item{\code{.default.TSS.downstream}}{Define the downstream range of transcription start site region.}
 \item{\code{.default.max.flankWindow}}{Define the max size of the flanking window surrounding the
 predicted RE-CpG.}
 \item{\code{.default.27k.total.probes}}{Total number of probes designed in Illumina 27k array.}
 \item{\code{.default.450k.total.probes}}{Total number of probes designed in Illumina 450k array.}
 \item{\code{.default.epic.total.probes}}{Total number of probes designed in Illumina EPIC array.}
 \item{\code{.default.450k.annotation}}{A character string associated with the Illumina 450k
 array annotation dataset.}
 \item{\code{.default.epic.annotation}}{A character string associated with the Illumina EPIC
 array annotation dataset.}
 \item{\code{.default.genomicRegionColNames}}{Define the names of the genomic regions for prediction.}
 \item{\code{.default.predictors}}{Define the names of predictors for RE methylation prediction.}
 \item{\code{.default.svmLinear.tune}}{Define the default \code{C} (Cost) parameter for Support
 Vector Machine (SVM) using linear kernel.}
 \item{\code{.default.svmRadial.tune}}{Define the default parameters (\code{C} and \code{sigma}) for SVM
 using Radial basis function kernel.}
 \item{\code{.default.xgbTree.tune}}{Define the default parameters (\code{nrounds}, \code{eta}, \code{max_depth},
 \code{gamma}, \code{colsample_bytree}, \code{min_child_weight}, and \code{subsample}) for Extreme Gradient
 Boosting.}
}
}

\examples{
# Display all default settings
remp_options()

# Display a specified setting
remp_options(".default.max.flankWindow")

# Change default maximum flanking window size to 2000
remp_options(.default.max.flankWindow = 2000)

# Reset all options
remp_reset()
}
