% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grooMethy.R
\name{grooMethy}
\alias{grooMethy}
\title{Groom methylation data to fix potential data issues}
\usage{
grooMethy(
  methyDat,
  Seq.GR = NULL,
  impute = TRUE,
  imputebyrow = TRUE,
  mapGenome = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{methyDat}{A \code{\link{RatioSet}}, \code{\link{GenomicRatioSet}}, \code{\link{DataFrame}},
\code{data.table}, \code{data.frame}, or \code{matrix} of Illumina BeadChip methylation data
(450k or EPIC array) or Illumina methylation percentage estimates by sequencing. If the data are prepared
as a \code{data.frame} or alike format, for Illumina array data, please make sure there is a column or row names 
are available to indicate the Illumina probe names (i.e. cg00000029); for sequencing methylation data, please provide 
the corresponding CpG location information in \code{Seq.GR}.}

\item{Seq.GR}{A \code{\link{GRanges}} object containing genomic locations of the CpGs profiled by sequencing
platforms. This parameter should not be \code{NULL} if the input methylation data \code{methyDat} are
obtained by sequencing platform. The order of \code{Seq.GR} should match the order of \code{methyDat}.
Note that the genomic location can be in either hg19 or hg38 build. See details.}

\item{impute}{If \code{TRUE}, K-Nearest Neighbouring imputation will be applied to fill
the missing values. Default = \code{TRUE}. See Details.}

\item{imputebyrow}{If \code{TRUE}, missing values will be imputed using similar values in row
(i.e., across samples); if \code{FALSE}, missing values will be imputed using similar values
in column (i.e., across CpGs). Default is \code{TRUE}.}

\item{mapGenome}{Logical parameter. If \code{TRUE}, function will return a \code{\link{GenomicRatioSet}}
object instead of a \code{\link{RatioSet}}. This function is not applicable for sequencing data.}

\item{verbose}{Logical parameter. Should the function be verbose?}
}
\value{
A \code{\link{RatioSet}} or \code{\link{GenomicRatioSet}} containing beta value and
M value of the methylation data.
}
\description{
\code{grooMethy} is used to automatically detect and fix data issues including zero beta
value, missing value, and infinite value.
}
\details{
For methylation data in beta value, if zero/one value exists, the logit transformation
from beta to M value will produce infinite value. Therefore, zero/one beta value
will be replaced with the smallest non-zero beta/largest non-one beta value found in the dataset.
\code{grooMethy} can also handle missing value (i.e. \code{NA} or \code{NaN}) using KNN imputation (see
\code{\link{impute.knn}}). The infinite value will be also treated as missing value for imputation.
If the original dataset is in beta value, \code{grooMethy} will first transform it to M value
before imputation is carried out. If the imputed value is out of the original range (which is possible when
\code{imputebyrow = FALSE}), mean value will be used instead. Warning: imputed
values for multimodal distributed CpGs (across samples) may not be correct. Please check package \code{ENmix} to
identify the CpGs with multimodal distribution. Please note that \code{grooMethy} is
also embedded in \code{\link{remp}} so the user can run \code{\link{remp}} directly without
explicitly running \code{grooMethy}. For sequencing methylation data, please specify the genomic location of CpGs
in a \code{GenomicRanges} object and specify it in \code{Seq.GR}. For an example of \code{Seq.GR}, Please
run \code{minfi::getLocations(IlluminaHumanMethylation450kanno.ilmn12.hg19)} (the row names of the CpGs in \code{Seq.GR}
can be \code{NULL}). The user should make sure the genome build of \code{Seq.GR} match the build specified 
in \code{genome} parameter of function \code{\link{initREMP}} and \code{\link{remprofile}} (default is \code{"hg19"}).
}
\examples{
# Get GM12878 methylation data (450k array)
if (!exists("GM12878_450k")) GM12878_450k <- getGM12878("450k")
GM12878_450k <- grooMethy(GM12878_450k, verbose = TRUE)

# Also works if data input is a matrix
grooMethy(minfi::getBeta(GM12878_450k), verbose = TRUE)
}
