% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REMPtools.R
\name{findRECpG}
\alias{findRECpG}
\title{Find RE-CpG genomic location given RE ranges information}
\usage{
findRECpG(
  RE,
  REtype = c("Alu", "L1", "ERV"),
  genome = c("hg19", "hg38"),
  be = NULL,
  verbose = FALSE
)
}
\arguments{
\item{RE}{A \code{\link{GRanges}} object of RE genomic location database. This
can be obtained by \code{\link{fetchRMSK}}.}

\item{REtype}{Type of RE. Currently \code{"Alu"}, \code{"L1"}, and \code{"ERV"} are supported.}

\item{genome}{Character parameter. Specify the build of human genome. Can be either \code{"hg19"} or 
\code{"hg38"}. User should make sure the genome build of \code{RE} is consistent with this parameter.}

\item{be}{A \code{\link{BiocParallel}} object containing back-end information that is
ready for parallel computing. This can be obtained by \code{\link{getBackend}}. If not specified,
non-parallel mode is used.}

\item{verbose}{logical parameter. Should the function be verbose?}
}
\value{
A \code{\link{GRanges}} object containing identified RE-CpG genomic
location data.
}
\description{
\code{findRECpG} is used to obtain RE-CpG genomic location data.
}
\details{
CpG site is defined as 5'-C-p-G-3'. It is reasonable to assume that the methylation
status across all CpG/CpG dyads are concordant. Maintenance methyltransferase exhibits
a preference for hemimethylated CpG/CpG dyads (methylated on one strand only).
As a result, methyaltion status of CpG sites in both forward and reverse strands are usually consistent.
Therefore, to accommodate the cytosine loci in both strands, the returned genomic
ranges cover the 'CG' sequence with width of 2. The 'strand' information indicates the strand of the RE.
Locating CpG sites in RE sequences can be computation intensive. It is recommanded to get more than
one work in the backend for a faster running speed.
}
\examples{
data(Alu.hg19.demo)
RE.CpG <- findRECpG(RE = Alu.hg19.demo, 
                    REtype = "Alu", 
                    genome = "hg19", 
                    verbose = TRUE)
RE.CpG

}
