% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCyjs-class.R
\docType{class}
\name{RCyjs-class}
\alias{RCyjs-class}
\alias{.RCyjs}
\alias{RCyjs}
\title{Create an RCyjs object}
\usage{
RCyjs(
  portRange = 16000:16100,
  title = "RCyjs",
  graph = graphNEL(),
  quiet = TRUE
)
}
\arguments{
\item{portRange}{The constructor looks for a free websocket port in this range.  16000:16100 by default}

\item{title}{Used for the web browser window, "RCyjs" by default}

\item{graph}{a Biocondcutor graphNEL object}

\item{quiet}{A logical variable controlling verbosity during execution}
}
\value{
An object of the RCyjs class
}
\description{
The RCyjs class provides an R interface to cytoscape.js, a rich, interactive, full-featured, javascript
network (graph) library.  One constructs an RCyjs instance on a specified port (default 9000),
the browser code is loaded, and a websocket connection opened.
}
\examples{
if(interactive()){
  g <- simpleDemoGraph()
  rcy <- RCyjs(title="rcyjs demo", graph=g)
  setNodeLabelRule(rcy, "label");
  setNodeSizeRule(rcy, "count", c(0, 30, 110), c(20, 50, 100));
  setNodeColorRule(rcy, "count", c(0, 100), c(colors$green, colors$red), mode="interpolate")
  redraw(rcy)
  layout(rcy, "cose")
  }

}
