% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tools.R
\name{mergeNetworks}
\alias{mergeNetworks}
\title{Merge Networks}
\usage{
mergeNetworks(
  sources = NULL,
  title = NULL,
  operation = "union",
  nodeKeys = NULL,
  nodeMergeMap = NULL,
  nodesOnly = FALSE,
  edgeKeys = NULL,
  edgeMergeMap = NULL,
  networkMergeMap = NULL,
  inNetworkMerge = TRUE,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{sources}{List of network names (max:2) to be merged.}

\item{title}{(optional) Title of the resulting merged network. Default is a
concatentation of operation and source network titles.}

\item{operation}{(optional) Type of merge: union (default), intersection or
difference.}

\item{nodeKeys}{(optional) An order-dependent list of columns to match
nodes across source networks. Default is "name" column for all sources.}

\item{nodeMergeMap}{(optional) A list of column merge records specifying
how to merge node table data. Each record should be of the form: 
c("network1 column", "network2 column", "merged column", "type"), where
column names are provided and type is String, Integer, Double or List.}

\item{nodesOnly}{(optional) If TRUE, this will merge the node tables and 
ignore edge and network table data. Default is FALSE.}

\item{edgeKeys}{(optional) An order-dependent list of columns to match 
edges across source networks. Default is "name" column for all sources.}

\item{edgeMergeMap}{(optional) A list of column merge records specifying
how to merge edge table data. Each record should be of the form: 
c("network1 column", "network2 column", "merged column", "type"), where
column names are provided and type is String, Integer, Double or List.}

\item{networkMergeMap}{(optional) A list of column merge records specifying
how to merge network table data. Each record should be of the form: 
c("network1 column", "network2 column", "merged column", "type"), where
column names are provided and type is String, Integer, Double or List.}

\item{inNetworkMerge}{(optional) If TRUE (default), nodes and edges with 
matching attributes in the same network will be merged.}

\item{base.url}{(optional) Ignore unless you need to specify a custom 
domain, port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported 
by this version of RCy3.}
}
\value{
SUID of resulting merged network
}
\description{
Combine networks via union, intersection, or difference 
operations. Lots of optional parameters choose from!
}
\examples{
\donttest{
mergeNetworks(c("Network 1", "Network 2"), "Merged Network")
mergeNetworks(c("my network","string network"), "Merged Network", 
              nodeKeys=c("HGNC","query term"))
}
}
