% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{createNetworkFromDataFrames}
\alias{createNetworkFromDataFrames}
\title{Create a network from data frames}
\usage{
createNetworkFromDataFrames(
  nodes = NULL,
  edges = NULL,
  title = "From dataframe",
  collection = "My Dataframe Network Collection",
  base.url = .defaultBaseUrl,
  ...
)
}
\arguments{
\item{nodes}{(data.frame) see details and examples below; default NULL to 
derive nodes from edge sources and targets}

\item{edges}{(data.frame) see details and examples below; default NULL for 
disconnected set of nodes}

\item{title}{(char) network name}

\item{collection}{(char) network collection name}

\item{base.url}{(optional) Ignore unless you need to specify a custom 
domain, port or version to connect to the CyREST API. Default is 
http://localhost:1234 and the latest version of the CyREST API supported by 
this version of RCy3.}

\item{...}{params for nodeSet2JSON() and edgeSet2JSON()}
}
\value{
(int) network SUID
}
\description{
Takes data frames for nodes and edges, as well as naming 
parameters to generate the JSON data format required by the "networks" POST 
operation via CyREST. Returns the network.suid and applies the perferred 
layout set in Cytoscape preferences.
}
\details{
NODES should contain a column of character strings named: id. This 
name can be overridden by the arg: node.id.list. Additional columns are 
loaded as node attributes. EDGES should contain columns of character strings 
named: source, target and interaction. These names can be overridden by
args: source.id.list, target.id.list, interaction.type.list. Additional 
columns are loaded as edge attributes. The 'interaction' list can contain a 
single value to apply to all rows; and if excluded altogether, the 
interaction type wiil be set to "interacts with". NOTE: attribute values of 
types (num) will be imported as (Double); (int) as (Integer); (chr) as 
(String); and (logical) as (Boolean). (Lists) will be imported as (Lists)
in CyREST v3.9+.
}
\examples{
\donttest{
nodes <- data.frame(id=c("node 0","node 1","node 2","node 3"),
           group=c("A","A","B","B"), # categorical strings
           score=as.integer(c(20,10,15,5))) # integers
edges <- data.frame(source=c("node 0","node 0","node 0","node 2"),
           target=c("node 1","node 2","node 3","node 3"),
           interaction=c("inhibits","interacts",
                         "activates","interacts"),  # optional
           weight=c(5.1,3.0,5.2,9.9)) # numeric

createNetworkFromDataFrames(nodes,edges)
}
}
