% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleBypasses.R
\name{setNodeShapeBypass}
\alias{setNodeShapeBypass}
\title{Set Node Shape Bypass}
\usage{
setNodeShapeBypass(
  node.names,
  new.shapes,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{node.names}{List of node names or SUIDs}

\item{new.shapes}{List of shapes, or single value. See \link{getNodeShapes}.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Override the shape for particular nodes.
}
\details{
This method permanently overrides any default values or mappings 
defined for this visual property of the node or nodes specified. This method
ultimately calls the generic function, \link{setNodePropertyBypass}, which 
can be used to set any visual property. To restore defaults and mappings, use
 \link{clearNodePropertyBypass}, see examples.
}
\examples{
\donttest{
setNodeShapeBypass('Node 1', 'ROUND_RECTANGLE')
setNodeShapeBypass(c('Node 1','Node 2'), 'ROUND_RECTANGLE')
clearNodePropertyBypass(c('Node 1','Node 2'), 'NODE_SHAPE')
}
}
\seealso{
{
\link{setNodePropertyBypass},
\link{clearNodePropertyBypass}
}
}
