% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkSelection.R
\name{selectEdgesAdjacentToNodes}
\alias{selectEdgesAdjacentToNodes}
\title{Select Edges Adjacent To Nodes}
\usage{
selectEdgesAdjacentToNodes(
  nodes,
  by.col = "name",
  selectNodes = TRUE,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{nodes}{List of node SUIDs, names or other column values}

\item{by.col}{Node table column to lookup up provide node values. Default is 
'name'.}

\item{selectNodes}{The default is TRUE. If TRUE, nodes will also be selected.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
Lists of SUIDs for selected nodes and edges
}
\description{
Takes list of node SUIDs, names or other column values and adds to the selection all edges
connected to those nodes, regardless of directionality.
}
\examples{
\donttest{
selectEdgesAdjacentToNodes()
}
}
