% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleMappings.R
\name{mapVisualProperty}
\alias{mapVisualProperty}
\title{Creates a mapping between an attribute and a visual property}
\usage{
mapVisualProperty(
  visual.prop,
  table.column,
  mapping.type,
  table.column.values,
  visual.prop.values,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{visual.prop}{(char) name of visual property to map}

\item{table.column}{(char) name of table column to map}

\item{mapping.type}{(char) continuous, discrete or passthrough (c,d,p)}

\item{table.column.values}{(list) list of values paired with visual.prop.values; skip for passthrough mapping}

\item{visual.prop.values}{(list) list of values paired with table.column.values; skip for passthrough mapping}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
(network=network, base.url=base.url) ready to convert into JSON by style mapping operations
}
\description{
Generates the appropriate data structure for the "mapping" parameter
in updateStyleMapping.
}
\details{
The paired list of values must be of the same length or mapping will fail.
For gradient mapping, you may include two additional visual.prop.values in the 
first and last positions to map respectively to values less than and greater 
than those specified in table.column.values. Mapping will also fail if the 
data type of table.column.values does not match that of the existing table.column. 
Note that all imported numeric data are stored as Integers or Doubles in 
Cytosacpe tables; and character or mixed data are stored as Strings.
}
\section{List of visual properties}{

\tabular{lll}{
Node Border Stroke \tab Edge Bend \tab Network Background Paint \cr
Node Border Paint \tab Edge Curved \tab Network Center X Location \cr
Node Border Transparency \tab Edge Label \tab Network Center Y Location \cr
Node Border Width \tab Edge Label Color \tab Network Center Z Location \cr
Node CustomGraphics 1-9 \tab Edge Label Font Face \tab Network Depth \cr
Node CustomGraphics Position 1-9 \tab Edge Label Font Size \tab Network Edge Selection \cr
Node CustomGraphics Size 1-9 \tab Edge Label Transparency \tab Network Height \cr
Node CustomPaint 1-9 \tab Edge Label Width \tab Network Node Selection \cr
Node Depth \tab Edge Line Type \tab Network Scale Factor \cr
Node Fill Color \tab Edge Paint \tab Network Size \cr
Node Height \tab Edge Selected \tab Network Title \cr
Node Label \tab Edge Selected Paint \tab Network Width \cr
Node Label Color \tab Edge Source Arrow Selected Paint \tab  \cr
Node Label Font Face \tab Edge Source Arrow Shape \tab  \cr
Node Label Font Size \tab Edge Source Arrow Size \tab  \cr
Node Label Position \tab Edge Source Arrow Unselected Paint \tab  \cr
Node Label Transparency \tab Edge Stroke Selected Paint \tab  \cr
Node Label Width \tab Edge Stroke Unselected Paint \tab  \cr
Node Network Image Visible \tab Edge Target Arrow Selected Paint \tab  \cr
Node Paint \tab Edge Target Arrow Shape \tab  \cr
Node Selected \tab Edge Target Arrow Size \tab  \cr
Node Selected Paint \tab Edge Target Arrow Unselected Paint \tab  \cr
Node Shape \tab Edge Tooltip \tab  \cr
Node Size \tab Edge Transparency \tab  \cr
Node Tooltip \tab Edge Unselected Paint \tab  \cr
Node Transparency \tab Edge Visible \tab  \cr
Node Visible \tab Edge Visual Property \tab  \cr
Node Width \tab Edge Width \tab  \cr
Node X Location \tab  \tab  \cr
Node Y Location \tab  \tab  \cr
Node Z Location \tab  \tab  \cr
}
}

\examples{
\donttest{
mapVisualProperty('node fill color','score','c',c(-4.0,0.0,9.0),c('#99CCFF','#FFFFFF','#FF7777'))
mapVisualProperty('node shape','type','d',c('protein','metabolite'),c('ellipse','rectangle'))
mapVisualProperty('node label','alias','p')
}
}
\seealso{
updateStyleMapping getVisualPropertyNames
}
