% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commands.R
\name{commandsGET}
\alias{commandsGET}
\title{Commands GET}
\usage{
commandsGET(cmd.string, base.url = .defaultBaseUrl)
}
\arguments{
\item{cmd.string}{(char) command}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
A \code{list}, \code{status} or None.
}
\description{
Using the same syntax as Cytoscape's Command Line Dialog,
this function converts a command string into a CyREST query URL, executes a GET
request, and parses the result content into an R list object.
The function check whether actual call is local or remote first. If remote,
requests will go through Jupyter-Bridge.
Extremely long commands may result in an immediate "URI Too Long" failure because
`commandsRun()` uses HTTP GET to call the CyREST API, and HTTP GET has known limitations.
You can use `commandsPost()` instead, though the return value will be different.
`commandsPost()` uses HTTP POST, which has no limitations.
}
\examples{
\donttest{
commandsGET('layout get preferred network=current')
commandsGET('network list properties network=current')
commandsGET('layout force-directed defaultNodeMass=1')
}
}
