% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCX-NodesAndEdges.R
\name{updateNodes}
\alias{updateNodes}
\alias{updateNodes.NodesAspect}
\alias{updateNodes.RCX}
\title{Update nodes}
\usage{
updateNodes(x, nodes, stopOnDuplicates = FALSE, keepOldIds = TRUE)

\method{updateNodes}{NodesAspect}(x, nodes, stopOnDuplicates = FALSE, keepOldIds = TRUE)

\method{updateNodes}{RCX}(x, nodes, stopOnDuplicates = FALSE, keepOldIds = TRUE)
}
\arguments{
\item{x}{\code{\link{RCX-object}} or \code{\link{Nodes}} object; (to which the new \code{\link{Nodes}} will be added)}

\item{nodes}{\code{\link{Nodes}} object; (the \code{\link{Nodes}}, that will be added)}

\item{stopOnDuplicates}{logical (optional); whether to stop, if duplicates in \code{id} column are found, or re-assign ids instead.}

\item{keepOldIds}{logical (optional); if ids are re-assigned, the original ids are kept in the column \code{oldId}}
}
\value{
\code{\link{Nodes}} or \link[=RCX-object]{RCX} object with added nodes
}
\description{
This functions add nodes in the form of a \code{\link{Nodes}} object to an other \code{\link{Nodes}} or an \code{\link{RCX-object}}.
}
\details{
When nodes should be added to a \code{\link{Nodes}} or a \code{\link{RCX-object}} object some conflicts may rise, since the aspects might use
the same IDs. If the aspects do not share any IDs, the two aspects are simply combined. Otherwise, the IDs of the new nodes are re-assinged
continuing with the next available ID (i.e. \code{\link{maxId}}(nodesAspect) + 1 and \code{\link{maxId}}(rcx$nodes) + 1, respectively).

To keep track of the changes, it is possible to keep the old IDs of the newly added nodes in the automatically added column \emph{oldId}.
This can be omitted by setting \emph{keepOldIds} to \code{FALSE}.
Otherwise, if a re-assignment of the IDs is not desired, this can be prevented by setting \emph{stopOnDuplicates} to \code{TRUE}.
This forces the function to stop and raise an error, if duplicated IDs are present.
}
\examples{
## create some nodes
nodes1 = createNodes(name = c("EGFR","AKT1","WNT"))
nodes2 = createNodes(name=c("CDK1", "CDK2", "CDK3"),
                     represents=c("HGNC:CDK1", 
                                  "Uniprot:P24941", 
                                  "Ensembl:ENSG00000250506"))

## simply add the nodes and keep old ids
nodes3 = updateNodes(nodes1, nodes2)

## add the nodes
nodes4 = updateNodes(nodes1, nodes2, keepOldIds=FALSE)

## force an error because of duplicated ids
try(updateNodes(nodes1, nodes2, stopOnDuplicates=TRUE))
## =>Error:
## Elements of "id" (in updateNodes) must not contain duplicates!

## create an RCX object with nodes
rcx = createRCX(nodes1)

## add additional nodes
rcx = updateNodes(rcx, nodes2, keepOldIds=FALSE)

## force an error becauses of duplicated ids
try(updateNodes(rcx, nodes2, stopOnDuplicates=TRUE))
## =>Error:
## Elements of "id" (in updateNodes) must not contain duplicates!
}
