% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_filterConfounders.R
\name{filterConfounders}
\alias{filterConfounders}
\title{Filters out the effect of known confounders. This is done by fitting
interactions of every taxon with the levels of the confounders.
It returns a modified offset matrix for the remainder
of the fitting procedure.}
\usage{
filterConfounders(
  muMarg,
  confMat,
  X,
  thetas,
  p,
  n,
  nleqslv.control,
  trended.dispersion,
  tol = 0.001,
  maxIt = 20,
  allowMissingness,
  naId
)
}
\arguments{
\item{muMarg}{a nxp matrix, the current offset}

\item{confMat}{a nxt confounder matrix}

\item{X}{the nxp data matrix}

\item{thetas}{a vector of length p with the current dispersion estimates}

\item{p}{an integer, the number of columns of X}

\item{n}{an integer, the number of rows of X}

\item{nleqslv.control}{see nleqslv()}

\item{trended.dispersion}{a vector of length p
with trended dispersion estimates}

\item{tol}{a scalar, the convergence tolerance}

\item{maxIt}{maximum number of iterations}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X

Fits the negative binomial mean parameters and overdispersion parameters
 iteratively.
 Convergence is determined based on the L2-norm
  of the absolute change of mean parameters}
}
\value{
a list with components:
\item{thetas}{new theta estimates}
\item{NB_params}{The estimated parameters of the interaction terms}
}
\description{
Filters out the effect of known confounders. This is done by fitting
interactions of every taxon with the levels of the confounders.
It returns a modified offset matrix for the remainder
of the fitting procedure.
}
