% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_LR_nb_Jac.R
\name{LR_nb_Jac}
\alias{LR_nb_Jac}
\title{A function that returns the Jacobian of the likelihood ratio}
\usage{
LR_nb_Jac(
  Alpha,
  X,
  CC,
  responseFun = c("linear", "quadratic", "nonparametric", "dynamic"),
  psi,
  NB_params,
  NB_params_noLab,
  d,
  alphaK,
  k,
  centMat,
  nLambda,
  nLambda1s,
  thetaMat,
  muMarg,
  n,
  ncols,
  preFabMat,
  envGradEst,
  allowMissingness,
  naId,
  ...
)
}
\arguments{
\item{Alpha}{a vector of length d + k*(2+(k-1)/2),
the environmental gradient plus the lagrangian multipliers}

\item{X}{the n-by-p count matrix}

\item{CC}{a n-by-d covariate vector}

\item{responseFun}{a character string indicating
the type of response function}

\item{psi}{a scalar, an importance parameter}

\item{NB_params}{Starting values for the NB_params}

\item{NB_params_noLab}{Starting values for the NB_params without label}

\item{d}{an integer, the number of covariate parameters}

\item{alphaK}{a matrix of environmental gradients of lower dimensions}

\item{k}{an integer, the current dimension}

\item{centMat}{a nLambda1s-by-d centering matrix}

\item{nLambda}{an integer, number of lagrangian multipliers}

\item{nLambda1s}{an integer, number of centering restrictions}

\item{thetaMat}{a matrix of size n-by-p with estimated dispersion parameters}

\item{muMarg}{an n-by-p offset matrix}

\item{n}{an integer, the number of rows of X}

\item{ncols}{a scalar, the number of columns of X}

\item{preFabMat}{a prefabricated matrix}

\item{envGradEst}{a character string,
indicating how the environmental gradient should be fitted.
'LR' using the likelihood-ratio criterion,
or 'ML' a full maximum likelihood solution}

\item{allowMissingness}{A boolean, are missing values present}

\item{naId}{The numeric index of the missing values in X}

\item{...}{Further arguments passed on to other functions}
}
\value{
A symmetric matrix, the evaluated Jacobian
}
\description{
A function that returns the Jacobian of the likelihood ratio
}
