% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_functions.R
\name{importGtf}
\alias{importGtf}
\title{importGtf}
\usage{
importGtf(
  filePath,
  saveObjectAsRds = TRUE,
  readFromRds = TRUE,
  overwriteObjectAsRds = FALSE,
  keepStandardChr = TRUE,
  ...
)
}
\arguments{
\item{filePath}{Path to a GTF file}

\item{saveObjectAsRds}{TRUE/FALSE (default:TRUE). If it is set to TRUE, a
GRanges object will be created and saved in RDS format
(<filePath>.granges.rds) so that importing can re-use this .rds file in
next run.}

\item{readFromRds}{TRUE/FALSE (default:TRUE). If it is set to TRUE,
annotation data will be imported from previously generated .rds file
(<filePath>.granges.rds).}

\item{overwriteObjectAsRds}{TRUE/FALSE (default:FALSE). If it is set to TRUE,
existing .rds file (<filePath>.granges.rds) will overwritten.}

\item{keepStandardChr}{TRUE/FALSE (default:TRUE). If it is set to TRUE,
\code{seqlevelsStyle} will be converted to 'UCSC' and
\code{keepStandardChromosomes} function  will be applied to only keep data
from the standard chromosomes.}

\item{...}{Other arguments passed to rtracklayer::import.gff function}
}
\value{
A \code{GRanges} object containing the coordinates of the annotated
  genomic features in an input GTF file
}
\description{
This function uses \code{rtracklayer::import.gff()} function to import genome
annoatation data from an Ensembl gtf file
}
\examples{
#import the data and write it into a .rds file
\dontrun{
importGtf(filePath='./Ensembl75.hg19.gtf')
}
#import the data but don't save it as RDS
\dontrun{
importGtf(filePath='./Ensembl75.hg19.gtf', saveObjectAsRds = FALSE)
}
#import the data and overwrite the previously generated
\dontrun{
importGtf(filePath='./Ensembl75.hg19.gtf', overwriteObjectAsRds = TRUE)
}

}
