% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_analysis_functions.R
\name{importBedFiles}
\alias{importBedFiles}
\title{importBedFiles}
\usage{
importBedFiles(filePaths, ...)
}
\arguments{
\item{filePaths}{A vector of paths to one or more BED files}

\item{...}{Other parameters passed to RCAS::importBed and
rtracklayer::import.bed function}
}
\value{
A \code{GRangesList} object containing the coordinates of the 
  intervals from multiple input BED files
}
\description{
This function is a wrapper that uses \code{RCAS::importBed()} function to 
import BED files as a GRangesList object
}
\examples{
input1 <- system.file("extdata", "testfile.bed", package='RCAS') 
input2 <- system.file("extdata", "testfile2.bed", package='RCAS') 
bedData <- importBedFiles(filePaths = c(input1, input2), 
keepStandardChr = TRUE) 
# when importing multiple bed files with different column names, it 
# is required to pass the common column names to be parsed from the 
# bed files
bedData <- importBedFiles(filePaths = c(input1, input2),
                 colnames = c('chrom', 'start', 'end', 'strand'))

}
