% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.omexml.R
\name{read.omexml}
\alias{read.omexml}
\title{Read OME-XML Metadata}
\usage{
read.omexml(file, filter.metadata = FALSE, proprietary.metadata = TRUE)
}
\arguments{
\item{file}{character, file name}

\item{filter.metadata}{logical, specifies whether ugly metadata (entries with unprintable characters, and extremely large entries) should be discarded from the metadata table}

\item{proprietary.metadata}{logical, should proprietary metadata be populated to OME-XML}
}
\value{
A string containing a dumped OME-XML DOM tree.
}
\description{
Read the OME-XML DOM tree.
}
\examples{
require(EBImage)
f = system.file("images", "nuclei.tif", package="EBImage")

omexml = read.omexml(f)
omexml
}
\seealso{
\code{\link{read.metadata}} for reading image metadata, \code{\link{read.image}} for reading image data
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2014-2023
}
