% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnotatedImage.R
\docType{class}
\name{AnnotatedImage-class}
\alias{AnnotatedImage-class}
\alias{.AnnotatedImage}
\alias{AnnotatedImage}
\alias{print.AnnotatedImage}
\alias{show,AnnotatedImage-method}
\alias{as.Image.AnnotatedImage}
\title{AnnotatedImage Class}
\usage{
AnnotatedImage(..., metadata = ImageMetadata())

\method{print}{AnnotatedImage}(x, short = FALSE, ...)

\S4method{show}{AnnotatedImage}(object)

\method{as.Image}{AnnotatedImage}(x)
}
\arguments{
\item{...}{arguments passed to the \linkS4class{Image} constructor.}

\item{metadata}{an \linkS4class{ImageMetadata} object containing image metadata}

\item{x}{an \linkS4class{AnnotatedImage} object.}

\item{short}{logical, turns off image data preview.}

\item{object}{an \linkS4class{AnnotatedImage} object}
}
\value{
\code{AnnotatedImage} returns a new \linkS4class{AnnotatedImage} object.

\code{as.Image} returns an \linkS4class{Image} object.
}
\description{
Extends the \linkS4class{Image} class from the \pkg{EBImage} package.
}
\section{Slots}{

\describe{
\item{\code{metadata}}{an \linkS4class{ImageMetadata} object containing image metadata}
}}

\examples{
f = mockFile(sizeX = 256, sizeY = 256)
img = read.image(f)
img
}
\seealso{
\linkS4class{AnnotatedImageList}
}
\author{
Andrzej Oleś <\email{andrzej.oles@gmail.com}>, 2014-2023
}
