% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools_internal.R
\encoding{UTF-8}
\name{validatePositiveIntegerVector}
\alias{validatePositiveIntegerVector}
\title{Validate that the input parameter is a vector of positive
\code{numeric}}
\usage{
validatePositiveIntegerVector(value, name)
}
\arguments{
\item{value}{a \code{vector} of \code{numeric} that will be validated.}

\item{name}{a \code{character} string that represents the name of the
parameter that is tested.}
}
\value{
The function returns \code{0L} when successful.
}
\description{
This function validates that the input parameter is
a \code{vector} of positive \code{numeric} values (vector of 1 entry or
more). All values have to be positive (>\code{0}).
If the parameter is not respecting the validation, the function generates
an error with a specific message.
}
\examples{

## The validation should be successful
RAIDS:::validatePositiveIntegerVector(value=c(1, 2 ,3, 5), name="test")

}
\author{
Pascal Belleau, Astrid Deschênes and Alexander Krasnitz
}
\keyword{internal}
